/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import mousio.etcd4j.responses.EtcdKeyAction;
import mousio.etcd4j.responses.EtcdKeysResponseParser;

public final class EtcdKeysResponse {
    public final EtcdKeyAction action;
    public final EtcdNode node;
    public final EtcdNode prevNode;
    public final String etcdClusterId;
    public final Long etcdIndex;
    public final Long raftIndex;
    public final Long raftTerm;

    protected EtcdKeysResponse(String action, EtcdNode node, EtcdNode prevNode, String etcdClusterId, Long etcdIndex, Long raftIndex, Long raftTerm) {
        this.action = EtcdKeyAction.valueOf(action);
        this.node = node;
        this.prevNode = prevNode;
        this.etcdClusterId = etcdClusterId;
        this.etcdIndex = etcdIndex;
        this.raftIndex = raftIndex;
        this.raftTerm = raftTerm;
    }

    public static final class EtcdNode {
        public final String key;
        public final boolean dir;
        public final Long createdIndex;
        public final Long modifiedIndex;
        public final String value;
        public final Date expiration;
        public final Long ttl;
        public final List<EtcdNode> nodes;

        protected EtcdNode(Boolean dir, String key, String value, long createdIndex, long modifiedIndex, String expiration, long ttl, List<EtcdNode> nodes) {
            this.dir = dir != null ? dir : false;
            this.key = key;
            this.value = value;
            this.createdIndex = createdIndex;
            this.modifiedIndex = modifiedIndex;
            this.ttl = ttl;
            this.nodes = nodes != null ? Collections.unmodifiableList(nodes) : Collections.unmodifiableList(Collections.emptyList());
            this.expiration = expiration != null ? EtcdKeysResponseParser.convertDate(expiration) : null;
        }
    }
}

