/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.manager.ConfigurationStateTracker;

final class ExtensionStateTracker {
    private final LoadingCache<Configuration, ConfigurationStateTracker> configurationsStates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Configuration, ConfigurationStateTracker>(){

        public ConfigurationStateTracker load(Configuration configuration) throws Exception {
            return new ConfigurationStateTracker();
        }
    });

    ExtensionStateTracker() {
    }

    <C> void registerConfigurationInstanceProvider(Configuration configuration, String providerName, ConfigurationInstanceProvider<C> configurationInstanceProvider) {
        this.getStateTracker(configuration).registerInstanceProvider(providerName, configurationInstanceProvider);
    }

    Map<String, ConfigurationInstanceProvider> getConfigurationInstanceProviders(Configuration configuration) {
        return ImmutableMap.copyOf(this.getStateTracker(configuration).getConfigurationInstanceProviders());
    }

    <C> void registerConfigurationInstance(Configuration configuration, String instanceName, C configurationInstance) {
        this.getStateTracker(configuration).registerInstance(instanceName, configurationInstance);
    }

    <C> OperationExecutor getOperationExecutor(Configuration configuration, C configurationInstance, OperationContext operationContext) {
        return this.getStateTracker(configuration).getOperationExecutor(configurationInstance, operationContext);
    }

    <C> void registerOperationExecutor(Configuration configuration, Operation operation, C configurationInstance, OperationExecutor executor) {
        this.getStateTracker(configuration).registerOperationExecutor(operation, configurationInstance, executor);
    }

    private ConfigurationStateTracker getStateTracker(Configuration configuration) {
        return (ConfigurationStateTracker)this.configurationsStates.getUnchecked((Object)configuration);
    }
}

