/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.Iterator;
import java.util.LinkedList;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CheckExclusiveAttribute
implements PreProcessor {
    public static final int NONE = -1;
    private String attribute;

    public CheckExclusiveAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        LinkedList<String> foundAttributes = new LinkedList<String>();
        boolean found = false;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String alias = SpringXMLUtils.attributeName((Attr)attribute);
            if (config.isIgnored(alias)) continue;
            if (attribute.equals(alias)) {
                found = true;
                continue;
            }
            if (!StringUtils.equals((String)element.getNamespaceURI(), (String)attribute.getNamespaceURI())) continue;
            foundAttributes.add(alias);
        }
        if (found && foundAttributes.size() > 0) {
            StringBuilder message = new StringBuilder("The attribute '");
            message.append(this.attribute);
            message.append("' cannot appear with the attribute");
            if (foundAttributes.size() > 1) {
                message.append("s");
            }
            Iterator others = foundAttributes.iterator();
            while (others.hasNext()) {
                message.append(" '");
                message.append(others.next());
                message.append("'");
            }
            message.append(" in element ");
            message.append(SpringXMLUtils.elementToString((Element)element));
            message.append(".");
            throw new CheckExclusiveAttributeException(message.toString());
        }
    }

    public static class CheckExclusiveAttributeException
    extends IllegalStateException {
        private CheckExclusiveAttributeException(String message) {
            super(message);
        }
    }
}

