/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.SPIServiceRegistry;
import org.mule.api.registry.ServiceRegistry;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.extension.ExtensionManager;
import org.mule.extension.introspection.Describer;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.resources.GenerableResource;
import org.mule.extension.resources.ResourcesGenerator;
import org.mule.extension.resources.spi.GenerableResourceContributor;
import org.mule.module.extension.internal.introspection.AnnotationsBasedDescriber;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.module.extension.internal.resources.AbstractResourcesGenerator;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.ArrayUtils;
import org.mule.util.IOUtils;
import org.springframework.util.ReflectionUtils;

public abstract class ExtensionsFunctionalTestCase
extends FunctionalTestCase {
    private final ServiceRegistry serviceRegistry = new SPIServiceRegistry();
    private final ExtensionFactory extensionFactory = new DefaultExtensionFactory(this.serviceRegistry);
    private ExtensionManager extensionManager;
    private File generatedResourcesDirectory;

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        this.createExtensionsManager();
    }

    protected Describer[] getDescribers() {
        return null;
    }

    protected Class<?>[] getAnnotatedExtensionClasses() {
        return null;
    }

    protected final void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(0, (ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                ((DefaultMuleContext)muleContext).setExtensionManager(ExtensionsFunctionalTestCase.this.extensionManager);
                if (ExtensionsFunctionalTestCase.this.extensionManager instanceof MuleContextAware) {
                    ((MuleContextAware)ExtensionsFunctionalTestCase.this.extensionManager).setMuleContext(muleContext);
                }
            }
        });
    }

    private List<GenerableResourceContributor> getGenerableResourceContributors() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(GenerableResourceContributor.class));
    }

    private void createExtensionsManager() throws Exception {
        Object[] annotatedClasses;
        this.extensionManager = new DefaultExtensionManager();
        Object[] describers = this.getDescribers();
        if (ArrayUtils.isEmpty((Object[])describers) && !ArrayUtils.isEmpty((Object[])(annotatedClasses = this.getAnnotatedExtensionClasses()))) {
            describers = new Describer[annotatedClasses.length];
            int i = 0;
            for (Object annotatedClass : annotatedClasses) {
                describers[i++] = new AnnotationsBasedDescriber((Class)annotatedClass);
            }
        }
        if (ArrayUtils.isEmpty((Object[])describers)) {
            this.extensionManager.discoverExtensions(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            this.loadExtensionsFromDescribers(this.extensionManager, (Describer[])describers);
        }
        this.generatedResourcesDirectory = this.getGenerationTargetDirectory();
        ExtensionsTestInfrastructureResourcesGenerator generator = new ExtensionsTestInfrastructureResourcesGenerator(this.serviceRegistry, this.generatedResourcesDirectory);
        List<GenerableResourceContributor> resourceContributors = this.getGenerableResourceContributors();
        for (Extension extension : this.extensionManager.getExtensions()) {
            for (GenerableResourceContributor contributor : resourceContributors) {
                contributor.contribute(extension, (ResourcesGenerator)generator);
            }
        }
        this.generateResourcesAndAddToClasspath((ResourcesGenerator)generator);
    }

    private void loadExtensionsFromDescribers(ExtensionManager extensionManager, Describer[] describers) {
        for (Describer describer : describers) {
            extensionManager.registerExtension(this.extensionFactory.createFrom(describer.describe()));
        }
    }

    private void generateResourcesAndAddToClasspath(ResourcesGenerator generator) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Method method = ReflectionUtils.findMethod(cl.getClass(), (String)"addURL", (Class[])new Class[]{URL.class});
        method.setAccessible(true);
        for (GenerableResource resource : generator.dumpAll()) {
            URL generatedResourceURL = new File(this.generatedResourcesDirectory, resource.getFilePath()).toURI().toURL();
            method.invoke((Object)cl, generatedResourceURL);
        }
    }

    private File getGenerationTargetDirectory() {
        URL url = IOUtils.getResourceAsUrl((String)this.getEffectiveConfigFile(), ((Object)((Object)this)).getClass(), (boolean)true, (boolean)true);
        File targetDirectory = new File(FileUtils.toFile((URL)url).getParentFile(), "META-INF");
        if (!targetDirectory.exists() && !targetDirectory.mkdir()) {
            throw new RuntimeException("Could not create target directory " + targetDirectory.getAbsolutePath());
        }
        return targetDirectory;
    }

    private String getEffectiveConfigFile() {
        String configFile = this.getConfigFile();
        if (configFile != null) {
            return configFile;
        }
        configFile = this.getConfigFileFromSplittable(this.getConfigurationResources());
        if (configFile != null) {
            return configFile;
        }
        configFile = this.getConfigFileFromSplittable(this.getConfigResources());
        if (configFile != null) {
            return configFile;
        }
        Object[] configFiles = this.getConfigFiles();
        if (!ArrayUtils.isEmpty((Object[])configFiles)) {
            return ((String)configFiles[0]).trim();
        }
        throw new IllegalArgumentException("No valid config file was specified");
    }

    private String getConfigFileFromSplittable(String configFile) {
        if (configFile != null) {
            return configFile.split(",")[0].trim();
        }
        return null;
    }

    private class ExtensionsTestInfrastructureResourcesGenerator
    extends AbstractResourcesGenerator {
        private File targetDirectory;

        private ExtensionsTestInfrastructureResourcesGenerator(ServiceRegistry serviceRegistry, File targetDirectory) {
            super(serviceRegistry);
            this.targetDirectory = targetDirectory;
        }

        protected void write(GenerableResource resource) {
            File targetFile = new File(this.targetDirectory, resource.getFilePath());
            try {
                FileUtils.write((File)targetFile, (CharSequence)resource.getContentBuilder().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

