/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.redis;

import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.ibatis.cache.Cache;
import org.mybatis.caches.redis.ConfigWithHost;
import org.mybatis.caches.redis.DummyReadWriteLock;
import org.mybatis.caches.redis.RedisCallback;
import org.mybatis.caches.redis.RedisConfigurationBuilder;
import org.mybatis.caches.redis.SerializeUtil;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public final class RedisCache
implements Cache {
    private final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    private String id;
    private static JedisPool pool;

    public RedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
        ConfigWithHost configWithHost = RedisConfigurationBuilder.getInstance().parseConfiguration();
        pool = new JedisPool((GenericObjectPoolConfig)configWithHost, configWithHost.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(RedisCallback callback) {
        Jedis jedis = pool.getResource();
        try {
            Object object = callback.doWithRedis(jedis);
            return object;
        }
        finally {
            jedis.close();
        }
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return (Integer)this.execute(new RedisCallback(){

            public Object doWithRedis(Jedis jedis) {
                Map result = jedis.hgetAll(RedisCache.this.id.toString().getBytes());
                return result.size();
            }
        });
    }

    public void putObject(final Object key, final Object value) {
        this.execute(new RedisCallback(){

            public Object doWithRedis(Jedis jedis) {
                jedis.hset(RedisCache.this.id.toString().getBytes(), key.toString().getBytes(), SerializeUtil.serialize(value));
                return null;
            }
        });
    }

    public Object getObject(final Object key) {
        return this.execute(new RedisCallback(){

            public Object doWithRedis(Jedis jedis) {
                return SerializeUtil.unserialize(jedis.hget(RedisCache.this.id.toString().getBytes(), key.toString().getBytes()));
            }
        });
    }

    public Object removeObject(final Object key) {
        return this.execute(new RedisCallback(){

            public Object doWithRedis(Jedis jedis) {
                return jedis.hdel(RedisCache.this.id.toString(), new String[]{key.toString()});
            }
        });
    }

    public void clear() {
        this.execute(new RedisCallback(){

            public Object doWithRedis(Jedis jedis) {
                jedis.del(RedisCache.this.id.toString());
                return null;
            }
        });
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public String toString() {
        return "Redis {" + this.id + "}";
    }
}

