/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class SqlScriptRunner {
    private String driver;
    private String url;
    private String userid;
    private String password;
    private String sourceFile;
    private Log log;

    public SqlScriptRunner(String sourceFile, String driver, String url, String userId, String password) throws MojoExecutionException {
        if (!StringUtility.stringHasValue((String)sourceFile)) {
            throw new MojoExecutionException("SQL script file is required");
        }
        if (!StringUtility.stringHasValue((String)driver)) {
            throw new MojoExecutionException("JDBC Driver is required");
        }
        if (!StringUtility.stringHasValue((String)url)) {
            throw new MojoExecutionException("JDBC URL is required");
        }
        this.sourceFile = sourceFile;
        this.driver = driver;
        this.url = url;
        this.userid = userId;
        this.password = password;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeScript() throws MojoExecutionException {
        Connection connection = null;
        try {
            Class driverClass = ObjectFactory.externalClassForName((String)this.driver);
            Driver theDriver = (Driver)driverClass.newInstance();
            Properties properties = new Properties();
            if (this.userid != null) {
                properties.setProperty("user", this.userid);
            }
            if (this.password != null) {
                properties.setProperty("password", this.password);
            }
            connection = theDriver.connect(this.url, properties);
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            BufferedReader br = this.getScriptReader();
            while (true) {
                String sql;
                if ((sql = this.readStatement(br)) == null) {
                    this.closeStatement(statement);
                    connection.commit();
                    br.close();
                    this.closeConnection(connection);
                    return;
                }
                statement.execute(sql);
            }
        }
        catch (ClassNotFoundException e) {
            try {
                throw new MojoExecutionException("Class not found: " + e.getMessage());
                catch (FileNotFoundException e2) {
                    throw new MojoExecutionException("File note found: " + this.sourceFile);
                }
                catch (SQLException e3) {
                    throw new MojoExecutionException("SqlException: " + e3.getMessage(), (Exception)e3);
                }
                catch (IOException e4) {
                    throw new MojoExecutionException("IOException: " + e4.getMessage(), (Exception)e4);
                }
                catch (InstantiationException e5) {
                    throw new MojoExecutionException("InstantiationException: " + e5.getMessage());
                }
                catch (IllegalAccessException e6) {
                    throw new MojoExecutionException("IllegalAccessException: " + e6.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                throw throwable;
            }
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.debug((CharSequence)"SQLException on close connection", (Throwable)e);
            }
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.log.debug((CharSequence)"SQLException on close statement", (Throwable)e);
            }
        }
    }

    private String readStatement(BufferedReader br) throws IOException {
        String s;
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("--") || !StringUtility.stringHasValue((String)line)) continue;
            if (line.endsWith(";")) {
                sb.append(' ');
                sb.append(line.substring(0, line.length() - 1));
                break;
            }
            sb.append(' ');
            sb.append(line);
        }
        if ((s = sb.toString().trim()).length() > 0) {
            this.log.debug((CharSequence)Messages.getString((String)"Progress.13", (String)s));
        }
        return s.length() > 0 ? s : null;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private BufferedReader getScriptReader() throws MojoExecutionException, IOException {
        BufferedReader answer;
        if (this.sourceFile.startsWith("classpath:")) {
            String resource = this.sourceFile.substring("classpath:".length());
            URL url = ObjectFactory.getResource((String)resource);
            InputStream is = url.openStream();
            if (is == null) {
                throw new MojoExecutionException("SQL script file does not exist: " + resource);
            }
            answer = new BufferedReader(new InputStreamReader(is));
        } else {
            File file = new File(this.sourceFile);
            if (!file.exists()) {
                throw new MojoExecutionException("SQL script file does not exist");
            }
            answer = new BufferedReader(new FileReader(file));
        }
        return answer;
    }
}

