/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.boot.autoconfigure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.io.VFS;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SpringBootVFS
extends VFS {
    private static Charset urlDecodingCharset;
    private final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

    public boolean isValid() {
        return true;
    }

    protected List<String> list(URL url, String path) throws IOException {
        String urlString = URLDecoder.decode(url.toString(), urlDecodingCharset.name());
        String baseUrlString = urlString.endsWith("/") ? urlString : urlString.concat("/");
        Resource[] resources = this.resourceResolver.getResources(baseUrlString + "**/*.class");
        return Stream.of(resources).map(resource -> SpringBootVFS.preserveSubpackageName(baseUrlString, resource, path)).collect(Collectors.toList());
    }

    public static void setUrlDecodingCharset(Charset charset) {
        urlDecodingCharset = charset;
    }

    private static String preserveSubpackageName(String baseUrlString, Resource resource, String rootPath) {
        try {
            return rootPath + (rootPath.endsWith("/") ? "" : "/") + resource.getURL().toString().substring(baseUrlString.length());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        SpringBootVFS.setUrlDecodingCharset(Charset.defaultCharset());
    }
}

