/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.nd4j.linalg.util.ConvConfigUtil;

public class Conv3DConfig
extends BaseConvolutionConfig {
    public static final String NDHWC = "NDHWC";
    public static final String NCDHW = "NCDHW";
    private long kD;
    private long kW;
    private long kH;
    private long sD;
    private long sW;
    private long sH;
    private long pD;
    private long pW;
    private long pH;
    private long dD;
    private long dW;
    private long dH;
    private boolean biasUsed;
    private PaddingMode paddingMode;
    private String dataFormat;

    public Conv3DConfig(long kD, long kW, long kH, long sD, long sW, long sH, long pD, long pW, long pH, long dD, long dW, long dH, boolean biasUsed, PaddingMode paddingMode, String dataFormat) {
        this.kD = kD;
        this.kW = kW;
        this.kH = kH;
        this.sD = sD;
        this.sW = sW;
        this.sH = sH;
        this.pD = pD;
        this.pW = pW;
        this.pH = pH;
        this.dD = dD;
        this.dW = dW;
        this.dH = dH;
        this.biasUsed = biasUsed;
        this.paddingMode = paddingMode;
        this.dataFormat = dataFormat;
        this.validate();
    }

    public boolean isNCDHW() {
        Preconditions.checkState((this.dataFormat.equalsIgnoreCase(NCDHW) || this.dataFormat.equalsIgnoreCase(NDHWC) ? 1 : 0) != 0, (String)"Data format must be one of %s or %s, got %s", (Object)NCDHW, (Object)NDHWC, (Object)this.dataFormat);
        return this.dataFormat.equalsIgnoreCase(NCDHW);
    }

    public void isNCDHW(boolean isNCDHW) {
        this.dataFormat = isNCDHW ? NCDHW : NDHWC;
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kD", this.kD);
        ret.put("kW", this.kW);
        ret.put("kH", this.kH);
        ret.put("sD", this.sD);
        ret.put("sW", this.sW);
        ret.put("sH", this.sH);
        ret.put("pD", this.pD);
        ret.put("pW", this.pW);
        ret.put("pH", this.pH);
        ret.put("dD", this.dD);
        ret.put("dW", this.dW);
        ret.put("dH", this.dH);
        ret.put("biasUsed", this.biasUsed);
        ret.put("dataFormat", this.dataFormat);
        ret.put("paddingMode", (Object)this.paddingMode);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate3D(this.kH, this.kW, this.kD, this.sH, this.sW, this.sD, this.pH, this.pW, this.pD, this.dH, this.dW, this.dD);
        Preconditions.checkArgument((this.dataFormat != null ? 1 : 0) != 0, (String)"Data format can't be null");
    }

    private static long $default$kD() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$sD() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$pD() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$dD() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static boolean $default$biasUsed() {
        return false;
    }

    private static String $default$dataFormat() {
        return NDHWC;
    }

    public static Conv3DConfigBuilder builder() {
        return new Conv3DConfigBuilder();
    }

    public long getKD() {
        return this.kD;
    }

    public long getKW() {
        return this.kW;
    }

    public long getKH() {
        return this.kH;
    }

    public long getSD() {
        return this.sD;
    }

    public long getSW() {
        return this.sW;
    }

    public long getSH() {
        return this.sH;
    }

    public long getPD() {
        return this.pD;
    }

    public long getPW() {
        return this.pW;
    }

    public long getPH() {
        return this.pH;
    }

    public long getDD() {
        return this.dD;
    }

    public long getDW() {
        return this.dW;
    }

    public long getDH() {
        return this.dH;
    }

    public boolean isBiasUsed() {
        return this.biasUsed;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setKD(long kD) {
        this.kD = kD;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setSD(long sD) {
        this.sD = sD;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setPD(long pD) {
        this.pD = pD;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setDD(long dD) {
        this.dD = dD;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setBiasUsed(boolean biasUsed) {
        this.biasUsed = biasUsed;
    }

    public void setPaddingMode(PaddingMode paddingMode) {
        this.paddingMode = paddingMode;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conv3DConfig)) {
            return false;
        }
        Conv3DConfig other = (Conv3DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKD() != other.getKD()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getSD() != other.getSD()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getPD() != other.getPD()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getDD() != other.getDD()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.isBiasUsed() != other.isBiasUsed()) {
            return false;
        }
        PaddingMode this$paddingMode = this.getPaddingMode();
        PaddingMode other$paddingMode = other.getPaddingMode();
        if (this$paddingMode == null ? other$paddingMode != null : !((Object)((Object)this$paddingMode)).equals((Object)other$paddingMode)) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conv3DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kD = this.getKD();
        result = result * 59 + (int)($kD >>> 32 ^ $kD);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $sD = this.getSD();
        result = result * 59 + (int)($sD >>> 32 ^ $sD);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $pD = this.getPD();
        result = result * 59 + (int)($pD >>> 32 ^ $pD);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $dD = this.getDD();
        result = result * 59 + (int)($dD >>> 32 ^ $dD);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        result = result * 59 + (this.isBiasUsed() ? 79 : 97);
        PaddingMode $paddingMode = this.getPaddingMode();
        result = result * 59 + ($paddingMode == null ? 43 : ((Object)((Object)$paddingMode)).hashCode());
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public String toString() {
        return "Conv3DConfig(kD=" + this.getKD() + ", kW=" + this.getKW() + ", kH=" + this.getKH() + ", sD=" + this.getSD() + ", sW=" + this.getSW() + ", sH=" + this.getSH() + ", pD=" + this.getPD() + ", pW=" + this.getPW() + ", pH=" + this.getPH() + ", dD=" + this.getDD() + ", dW=" + this.getDW() + ", dH=" + this.getDH() + ", biasUsed=" + this.isBiasUsed() + ", paddingMode=" + (Object)((Object)this.getPaddingMode()) + ", dataFormat=" + this.getDataFormat() + ")";
    }

    public Conv3DConfig() {
        this.kD = Conv3DConfig.$default$kD();
        this.kW = Conv3DConfig.$default$kW();
        this.kH = Conv3DConfig.$default$kH();
        this.sD = Conv3DConfig.$default$sD();
        this.sW = Conv3DConfig.$default$sW();
        this.sH = Conv3DConfig.$default$sH();
        this.pD = Conv3DConfig.$default$pD();
        this.pW = Conv3DConfig.$default$pW();
        this.pH = Conv3DConfig.$default$pH();
        this.dD = Conv3DConfig.$default$dD();
        this.dW = Conv3DConfig.$default$dW();
        this.dH = Conv3DConfig.$default$dH();
        this.biasUsed = Conv3DConfig.$default$biasUsed();
        this.dataFormat = Conv3DConfig.$default$dataFormat();
    }

    public static class Conv3DConfigBuilder {
        private boolean kD$set;
        private long kD$value;
        private boolean kW$set;
        private long kW$value;
        private boolean kH$set;
        private long kH$value;
        private boolean sD$set;
        private long sD$value;
        private boolean sW$set;
        private long sW$value;
        private boolean sH$set;
        private long sH$value;
        private boolean pD$set;
        private long pD$value;
        private boolean pW$set;
        private long pW$value;
        private boolean pH$set;
        private long pH$value;
        private boolean dD$set;
        private long dD$value;
        private boolean dW$set;
        private long dW$value;
        private boolean dH$set;
        private long dH$value;
        private boolean biasUsed$set;
        private boolean biasUsed$value;
        private PaddingMode paddingMode;
        private boolean dataFormat$set;
        private String dataFormat$value;

        Conv3DConfigBuilder() {
        }

        public Conv3DConfigBuilder kD(long kD) {
            this.kD$value = kD;
            this.kD$set = true;
            return this;
        }

        public Conv3DConfigBuilder kW(long kW) {
            this.kW$value = kW;
            this.kW$set = true;
            return this;
        }

        public Conv3DConfigBuilder kH(long kH) {
            this.kH$value = kH;
            this.kH$set = true;
            return this;
        }

        public Conv3DConfigBuilder sD(long sD) {
            this.sD$value = sD;
            this.sD$set = true;
            return this;
        }

        public Conv3DConfigBuilder sW(long sW) {
            this.sW$value = sW;
            this.sW$set = true;
            return this;
        }

        public Conv3DConfigBuilder sH(long sH) {
            this.sH$value = sH;
            this.sH$set = true;
            return this;
        }

        public Conv3DConfigBuilder pD(long pD) {
            this.pD$value = pD;
            this.pD$set = true;
            return this;
        }

        public Conv3DConfigBuilder pW(long pW) {
            this.pW$value = pW;
            this.pW$set = true;
            return this;
        }

        public Conv3DConfigBuilder pH(long pH) {
            this.pH$value = pH;
            this.pH$set = true;
            return this;
        }

        public Conv3DConfigBuilder dD(long dD) {
            this.dD$value = dD;
            this.dD$set = true;
            return this;
        }

        public Conv3DConfigBuilder dW(long dW) {
            this.dW$value = dW;
            this.dW$set = true;
            return this;
        }

        public Conv3DConfigBuilder dH(long dH) {
            this.dH$value = dH;
            this.dH$set = true;
            return this;
        }

        public Conv3DConfigBuilder biasUsed(boolean biasUsed) {
            this.biasUsed$value = biasUsed;
            this.biasUsed$set = true;
            return this;
        }

        public Conv3DConfigBuilder paddingMode(PaddingMode paddingMode) {
            this.paddingMode = paddingMode;
            return this;
        }

        public Conv3DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public Conv3DConfig build() {
            long kD$value = this.kD$value;
            if (!this.kD$set) {
                kD$value = Conv3DConfig.$default$kD();
            }
            long kW$value = this.kW$value;
            if (!this.kW$set) {
                kW$value = Conv3DConfig.$default$kW();
            }
            long kH$value = this.kH$value;
            if (!this.kH$set) {
                kH$value = Conv3DConfig.$default$kH();
            }
            long sD$value = this.sD$value;
            if (!this.sD$set) {
                sD$value = Conv3DConfig.$default$sD();
            }
            long sW$value = this.sW$value;
            if (!this.sW$set) {
                sW$value = Conv3DConfig.$default$sW();
            }
            long sH$value = this.sH$value;
            if (!this.sH$set) {
                sH$value = Conv3DConfig.$default$sH();
            }
            long pD$value = this.pD$value;
            if (!this.pD$set) {
                pD$value = Conv3DConfig.$default$pD();
            }
            long pW$value = this.pW$value;
            if (!this.pW$set) {
                pW$value = Conv3DConfig.$default$pW();
            }
            long pH$value = this.pH$value;
            if (!this.pH$set) {
                pH$value = Conv3DConfig.$default$pH();
            }
            long dD$value = this.dD$value;
            if (!this.dD$set) {
                dD$value = Conv3DConfig.$default$dD();
            }
            long dW$value = this.dW$value;
            if (!this.dW$set) {
                dW$value = Conv3DConfig.$default$dW();
            }
            long dH$value = this.dH$value;
            if (!this.dH$set) {
                dH$value = Conv3DConfig.$default$dH();
            }
            boolean biasUsed$value = this.biasUsed$value;
            if (!this.biasUsed$set) {
                biasUsed$value = Conv3DConfig.$default$biasUsed();
            }
            String dataFormat$value = this.dataFormat$value;
            if (!this.dataFormat$set) {
                dataFormat$value = Conv3DConfig.$default$dataFormat();
            }
            return new Conv3DConfig(kD$value, kW$value, kH$value, sD$value, sW$value, sH$value, pD$value, pW$value, pH$value, dD$value, dW$value, dH$value, biasUsed$value, this.paddingMode, dataFormat$value);
        }

        public String toString() {
            return "Conv3DConfig.Conv3DConfigBuilder(kD$value=" + this.kD$value + ", kW$value=" + this.kW$value + ", kH$value=" + this.kH$value + ", sD$value=" + this.sD$value + ", sW$value=" + this.sW$value + ", sH$value=" + this.sH$value + ", pD$value=" + this.pD$value + ", pW$value=" + this.pW$value + ", pH$value=" + this.pH$value + ", dD$value=" + this.dD$value + ", dW$value=" + this.dW$value + ", dH$value=" + this.dH$value + ", biasUsed$value=" + this.biasUsed$value + ", paddingMode=" + (Object)((Object)this.paddingMode) + ", dataFormat$value=" + this.dataFormat$value + ")";
        }
    }
}

