/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Linspace
extends DynamicCustomOp {
    private DataType dataType;
    private double start;
    private double stop;
    private long elements;

    public Linspace(SameDiff sameDiff, DataType dataType, double start, double stop, long number) {
        this(sameDiff, sameDiff.constant(start), sameDiff.constant(stop), sameDiff.constant(number), dataType);
    }

    public Linspace(SameDiff sameDiff, SDVariable from, SDVariable to, SDVariable length, DataType dataType) {
        super(sameDiff, new SDVariable[]{from, to, length});
        this.dataType = dataType;
        this.addDArgument(dataType);
    }

    public Linspace(DataType dataType, double start, double stop, long number) {
        this(start, stop, number, dataType);
    }

    public Linspace(DataType dataType, INDArray start, INDArray stop, INDArray number) {
        this(start, stop, number, dataType);
    }

    public Linspace(@NonNull INDArray start, @NonNull INDArray stop, @NonNull INDArray number, @NonNull DataType dataType) {
        super(new INDArray[]{start, stop, number}, null);
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (stop == null) {
            throw new NullPointerException("stop is marked non-null but is null");
        }
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        this.addDArgument(dataType);
    }

    public Linspace(double start, double stop, long number, @NonNull DataType dataType) {
        super(new INDArray[0], null);
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        this.addDArgument(dataType);
        this.start = start;
        this.stop = stop;
        this.elements = number;
        this.addTArgument(this.start, this.stop);
        this.addIArgument(this.elements);
    }

    public Linspace() {
    }

    @Override
    public String opName() {
        return "lin_space";
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        return Collections.singletonList(this.dataType);
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "LinSpace";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.dataType = TFGraphMapper.convertType(attributesForNode.get("T").getType());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Arrays.asList(this.sameDiff.zerosLike(this.arg(0)), this.sameDiff.zerosLike(this.arg(1)), this.sameDiff.zerosLike(this.arg(2)));
    }
}

