/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.clip;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ClipByValue
extends DynamicCustomOp {
    private double clipValueMin;
    private double clipValueMax;

    public ClipByValue(@NonNull INDArray input, double clipValueMin, double clipValueMax) {
        super(null, new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    public ClipByValue() {
    }

    public ClipByValue(SameDiff sameDiff, SDVariable x, double clipValueMin, double clipValueMax, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{x});
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.inplaceCall = inPlace;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    public ClipByValue(SameDiff sameDiff, SDVariable x, double clipValueMin, double clipValueMax) {
        super(null, sameDiff, new SDVariable[]{x});
        this.clipValueMin = clipValueMin;
        this.clipValueMax = clipValueMax;
        this.addTArgument(clipValueMin, clipValueMax);
    }

    public ClipByValue(INDArray x, INDArray clipValueMin, INDArray clipValueMax) {
        super(null, new INDArray[]{x, clipValueMin, clipValueMax}, null);
    }

    public ClipByValue(SameDiff sd, SDVariable x, SDVariable clipValueMin, SDVariable clipValueMax) {
        super(sd, new SDVariable[]{x, clipValueMin, clipValueMax});
    }

    @Override
    public String opName() {
        return "ClipByValue";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable notClippedLower = this.sameDiff.gt(this.arg(), this.clipValueMin).castTo(this.arg().dataType());
        SDVariable notClippedUpper = this.sameDiff.lt(this.arg(), this.clipValueMax).castTo(this.arg().dataType());
        SDVariable ret = notClippedLower.mul(notClippedUpper).mul(grad.get(0));
        return Collections.singletonList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && !inputDataTypes.isEmpty() ? 1 : 0) != 0, (String)"Expected at least 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return Arrays.asList(inputDataTypes.get(inputDataTypes.size() - 1));
    }
}

