/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.DotProductAttentionBp;

public class DotProductAttention
extends DynamicCustomOp {
    private boolean withWeights;
    private boolean scaled;

    public DotProductAttention(SameDiff sameDiff, SDVariable queries, SDVariable keys, SDVariable values, SDVariable mask, boolean scaled, boolean withWeights) {
        SDVariable[] sDVariableArray;
        if (mask == null) {
            SDVariable[] sDVariableArray2 = new SDVariable[3];
            sDVariableArray2[0] = queries;
            sDVariableArray2[1] = keys;
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[2] = values;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[4];
            sDVariableArray3[0] = queries;
            sDVariableArray3[1] = keys;
            sDVariableArray3[2] = values;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[3] = mask;
        }
        super(null, sameDiff, sDVariableArray, false);
        this.scaled = scaled;
        this.withWeights = withWeights;
        this.addIArgument(scaled ? 1 : 0);
        this.addIArgument(withWeights ? 1 : 0);
    }

    public DotProductAttention(@NonNull INDArray queries, @NonNull INDArray keys, @NonNull INDArray values, INDArray mask, boolean scaled) {
        this(queries, keys, values, mask, scaled, false);
        if (queries == null) {
            throw new NullPointerException("queries is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
    }

    public DotProductAttention(@NonNull INDArray queries, @NonNull INDArray keys, @NonNull INDArray values, INDArray mask, boolean scaled, boolean withWeights) {
        super(DotProductAttention.wrapFilterNull(queries, keys, values, mask), null);
        if (queries == null) {
            throw new NullPointerException("queries is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.scaled = scaled;
        this.withWeights = withWeights;
        this.addIArgument(scaled ? 1 : 0);
        this.addIArgument(withWeights ? 1 : 0);
    }

    @Override
    public String opName() {
        return "dot_product_attention";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradient) {
        SDVariable mask = this.args().length == 4 ? this.arg(3) : null;
        return Arrays.asList(new DotProductAttentionBp(this.sameDiff, this.arg(0), this.arg(1), this.arg(2), gradient.get(0), mask, this.scaled).outputVariables());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 3 || dataTypes.size() == 4) ? 1 : 0) != 0, (String)"Expected exactly 3 or 4 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (int i = 0; i < dataTypes.size(); ++i) {
            Preconditions.checkState((boolean)dataTypes.get(i).isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            if (i <= 0) continue;
            Preconditions.checkState((first == dataTypes.get(i) ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        if (this.withWeights) {
            return Arrays.asList(first, first);
        }
        return Collections.singletonList(first);
    }

    @Override
    public int getNumOutputs() {
        if (this.withWeights) {
            return 2;
        }
        return 1;
    }

    public DotProductAttention() {
    }
}

