/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing.conditions;

import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.BaseCondition;
import org.nd4j.linalg.indexing.conditions.Conditions;

public class AbsoluteEquals
extends BaseCondition {
    private double eps = Nd4j.EPS_THRESHOLD;

    public AbsoluteEquals() {
        this(0.0);
    }

    public AbsoluteEquals(Number value) {
        this(value, Nd4j.EPS_THRESHOLD);
    }

    public AbsoluteEquals(Number value, Number eps) {
        super(value);
        this.eps = eps.doubleValue();
    }

    @Override
    public void setValue(Number value) {
    }

    @Override
    public double epsThreshold() {
        return this.eps;
    }

    @Override
    public Conditions.ConditionMode conditionType() {
        return Conditions.ConditionMode.ABS_EQUALS;
    }

    @Override
    public Boolean apply(Number input) {
        return Math.abs(input.doubleValue()) == this.value.doubleValue();
    }
}

