/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.AdaMax;

public class AdaMaxUpdater
implements GradientUpdater<AdaMax> {
    public static final String M_STATE = "M";
    public static final String U_STATE = "V";
    private final AdaMax config;
    private INDArray m;
    private INDArray u;
    private char gradientReshapeOrder;

    public AdaMaxUpdater(AdaMax config) {
        this.config = config;
    }

    @Override
    public void setState(@NonNull Map<String, INDArray> stateMap, boolean initialize) {
        if (stateMap == null) {
            throw new NullPointerException("stateMap is marked non-null but is null");
        }
        if (!stateMap.containsKey(M_STATE) || !stateMap.containsKey(U_STATE) || stateMap.size() != 2) {
            throw new IllegalStateException("State map should contain only keys [M,V] but has keys " + stateMap.keySet());
        }
        this.m = stateMap.get(M_STATE);
        this.u = stateMap.get(U_STATE);
    }

    @Override
    public Map<String, INDArray> getState() {
        HashMap<String, INDArray> r = new HashMap<String, INDArray>();
        r.put(M_STATE, this.m);
        r.put(U_STATE, this.u);
        return r;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, long[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        long length = viewArray.length();
        this.m = viewArray.get(NDArrayIndex.point(0L), NDArrayIndex.interval(0L, length / 2L));
        this.u = viewArray.get(NDArrayIndex.point(0L), NDArrayIndex.interval(length / 2L, length));
        this.m = Shape.newShapeNoCopy(this.m, gradientShape, gradientOrder == 'f');
        this.u = Shape.newShapeNoCopy(this.u, gradientShape, gradientOrder == 'f');
        if (this.m == null || this.u == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.m == null || this.u == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double lr = this.config.getLearningRate(iteration, epoch);
        double b1 = this.config.getBeta1();
        double b2 = this.config.getBeta2();
        double eps = this.config.getEpsilon();
        Nd4j.exec(new org.nd4j.linalg.api.ops.impl.updaters.AdaMaxUpdater(gradient, this.u, this.m, lr, b1, b2, eps, iteration));
    }

    @Override
    public AdaMax getConfig() {
        return this.config;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getU() {
        return this.u;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setU(INDArray u) {
        this.u = u;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaMaxUpdater)) {
            return false;
        }
        AdaMaxUpdater other = (AdaMaxUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGradientReshapeOrder() != other.getGradientReshapeOrder()) {
            return false;
        }
        AdaMax this$config = this.getConfig();
        AdaMax other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$u = this.getU();
        INDArray other$u = other.getU();
        return !(this$u == null ? other$u != null : !this$u.equals(other$u));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaMaxUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGradientReshapeOrder();
        AdaMax $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 43 : $m.hashCode());
        INDArray $u = this.getU();
        result = result * 59 + ($u == null ? 43 : $u.hashCode());
        return result;
    }

    public String toString() {
        return "AdaMaxUpdater(config=" + this.getConfig() + ", m=" + this.getM() + ", u=" + this.getU() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

