/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.DataTypeEx;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.custom.Flatten;
import org.nd4j.linalg.api.ops.impl.shape.Concat;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.compression.CompressionDescriptor;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.CompressionUtils;
import org.nd4j.linalg.cpu.nativecpu.NDArray;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuBlas;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLapack;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel1;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel2;
import org.nd4j.linalg.cpu.nativecpu.blas.CpuLevel3;
import org.nd4j.linalg.cpu.nativecpu.buffer.BaseCpuDataBuffer;
import org.nd4j.linalg.cpu.nativecpu.buffer.LongBuffer;
import org.nd4j.linalg.cpu.nativecpu.buffer.Utf8Buffer;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.BaseNativeNDArrayFactory;
import org.nd4j.nativeblas.LongPointerWrapper;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuNDArrayFactory
extends BaseNativeNDArrayFactory {
    private static final Logger log = LoggerFactory.getLogger(CpuNDArrayFactory.class);
    protected ThreadLocal<PointerPointer> extrazA = new ThreadLocal();
    protected ThreadLocal<PointerPointer> extrazB = new ThreadLocal();
    protected ThreadLocal<Integer> extrazSize = new ThreadLocal();

    public CpuNDArrayFactory() {
    }

    public CpuNDArrayFactory(DataType dtype, Character order2) {
        super(dtype, order2);
    }

    public CpuNDArrayFactory(DataType dtype, char order2) {
        super(dtype, order2);
    }

    public void createBlas() {
        String optLevel;
        String binLevel;
        int optimalLevel;
        int binaryLevel;
        if (!this.nativeOps.isMinimalRequirementsMet()) {
            binaryLevel = this.nativeOps.binaryLevel();
            optimalLevel = this.nativeOps.optimalLevel();
            binLevel = CpuNDArrayFactory.cpuBinaryLevelToName(binaryLevel);
            optLevel = CpuNDArrayFactory.cpuBinaryLevelToName(optimalLevel);
            log.warn("*********************************** CPU Feature Check Failed ***********************************");
            log.error("Error initializing ND4J: Attempting to use " + binLevel + " ND4J binary on a CPU with only " + optLevel + " support");
            log.error(binLevel + " binaries cannot be run on a CPU without these instructions. See deeplearning4j.org/cpu for more details");
            log.error("ND4J will now exit.");
            log.warn("************************************************************************************************");
            System.exit(1);
        }
        binaryLevel = this.nativeOps.binaryLevel();
        optimalLevel = this.nativeOps.optimalLevel();
        binLevel = CpuNDArrayFactory.cpuBinaryLevelToName(binaryLevel);
        optLevel = CpuNDArrayFactory.cpuBinaryLevelToName(optimalLevel);
        log.info("Binary level " + binLevel + " optimization level " + optLevel);
        this.blas = new CpuBlas();
        PointerPointer functions = new PointerPointer(10L);
        functions.put(0L, Loader.addressof((String)"cblas_sgemv"));
        functions.put(1L, Loader.addressof((String)"cblas_dgemv"));
        functions.put(2L, Loader.addressof((String)"cblas_sgemm"));
        functions.put(3L, Loader.addressof((String)"cblas_dgemm"));
        functions.put(4L, Loader.addressof((String)"cblas_sgemm_batch"));
        functions.put(5L, Loader.addressof((String)"cblas_dgemm_batch"));
        functions.put(6L, Loader.addressof((String)"LAPACKE_sgesvd"));
        functions.put(7L, Loader.addressof((String)"LAPACKE_dgesvd"));
        functions.put(8L, Loader.addressof((String)"LAPACKE_sgesdd"));
        functions.put(9L, Loader.addressof((String)"LAPACKE_dgesdd"));
        this.nativeOps.initializeFunctions(functions);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
    }

    private static String cpuBinaryLevelToName(int level) {
        switch (level) {
            case 3: {
                return "AVX512";
            }
            case 2: {
                return "AVX/AVX2";
            }
        }
        return "Generic x86";
    }

    public void createLevel1() {
        this.level1 = new CpuLevel1();
    }

    public void createLevel2() {
        this.level2 = new CpuLevel2();
    }

    public void createLevel3() {
        this.level3 = new CpuLevel3();
    }

    public void createLapack() {
        this.lapack = new CpuLapack();
    }

    public INDArray create(int[] shape, DataBuffer buffer) {
        return new NDArray(shape, buffer);
    }

    public INDArray create(double[][] data) {
        return new NDArray(data);
    }

    public INDArray create(double[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public INDArray create(DataBuffer data) {
        return new NDArray(data);
    }

    public INDArray create(DataBuffer data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    public INDArray create(long rows, long columns, long[] stride, long offset) {
        return this.create(new long[]{rows, columns}, stride, offset);
    }

    public INDArray create(int[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0L, ordering);
    }

    public INDArray create(long[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering);
    }

    public INDArray createUninitialized(int[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0L, ordering, false);
    }

    public INDArray createUninitialized(long[] shape, char ordering) {
        return new NDArray(shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, false);
    }

    public INDArray create(DataType dataType, long[] shape, char ordering, MemoryWorkspace workspace) {
        return new NDArray(dataType, shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, workspace);
    }

    public INDArray create(DataType dataType, long[] shape, long[] strides, char ordering, MemoryWorkspace workspace) {
        return new NDArray(dataType, shape, strides, 0L, ordering);
    }

    public INDArray createUninitialized(DataType dataType, long[] shape, char ordering, MemoryWorkspace workspace) {
        return new NDArray(dataType, shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, false, workspace);
    }

    public INDArray createUninitializedDetached(DataType dataType, char ordering, long ... shape) {
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        NDArray ret = new NDArray(dataType, shape, Nd4j.getStrides((long[])shape, (char)ordering), 0L, ordering, false);
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return ret;
    }

    public INDArray create(DataBuffer data, int[] newShape, int[] newStride, long offset, char ordering) {
        return new NDArray(data, newShape, newStride, offset, ordering);
    }

    public INDArray create(float[] data, int[] shape, long offset, Character order2) {
        return new NDArray(data, shape, offset, order2.charValue());
    }

    public INDArray create(float[] data, long[] shape, long offset, Character order2) {
        return new NDArray(data, shape, offset, order2.charValue());
    }

    public INDArray create(float[] data, long rows, long columns, int[] stride, long offset, char ordering) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset, ordering);
    }

    public INDArray create(double[] data, int[] shape, char ordering) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, ordering);
    }

    public INDArray create(double[] data, long[] shape, char ordering) {
        return this.create(data, shape, Character.valueOf(ordering).charValue());
    }

    public INDArray create(float[] data, long[] shape, char ordering) {
        return this.create(data, shape, Character.valueOf(ordering).charValue());
    }

    public INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return new NDArray(list, shape, ordering);
    }

    public INDArray create(List<INDArray> list, long[] shape, char ordering) {
        return new NDArray(list, shape, ordering);
    }

    public INDArray create(double[] data, int[] shape, long offset) {
        return new NDArray(Nd4j.createBuffer((double[])data), shape, offset);
    }

    public INDArray create(double[] data, long[] shape, long offset, Character order2) {
        return new NDArray(data, shape, offset, order2.charValue());
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createTypedBuffer((double[])data, (DataType)DataType.DOUBLE), shape, stride, offset, ordering);
    }

    public INDArray create(double[] data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createTypedBuffer((double[])data, (DataType)DataType.DOUBLE), shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(Nd4j.createTypedBuffer((float[])data, (DataType)DataType.FLOAT), shape, stride, offset, ordering);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(float[] data, long[] shape, long[] stride, char order2, DataType dataType) {
        return new NDArray(data, shape, stride, 0L, order2);
    }

    public INDArray create(double[] data, long[] shape, long[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(double[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((double[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((float[])data, (DataType)dataType), shape, stride, order2, dataType, workspace);
    }

    public INDArray create(double[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((double[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(long[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((long[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(int[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((int[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(short[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((short[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(byte[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((byte[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(boolean[] data, long[] shape, long[] stride, char order2, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((boolean[])data, (DataType)dataType), shape, stride, order2, dataType);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((float[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(long[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((long[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(int[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((int[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(short[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((short[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(boolean[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((boolean[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(byte[] data, long[] shape, long[] stride, DataType dataType, MemoryWorkspace workspace) {
        return new NDArray(Nd4j.createTypedBuffer((byte[])data, (DataType)dataType), shape, stride, Nd4j.order().charValue(), dataType);
    }

    public INDArray create(DataBuffer data, long[] shape) {
        return new NDArray(data, shape);
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset) {
        return this.create(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset, char ordering) {
        return new NDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset, long ews, char ordering) {
        return new NDArray(data, shape, stride, offset, ews, ordering);
    }

    public INDArray create(DataBuffer data, long[] shape, long[] stride, long offset, char ordering, DataType dataType) {
        return new NDArray(data, shape, stride, offset, ordering, dataType);
    }

    public INDArray create(float[] data, long[] shape, long[] stride, char order2, long offset) {
        return new NDArray(data, shape, stride, offset, order2);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset);
    }

    public INDArray create(DataBuffer data, int[] shape) {
        return new NDArray(data, shape);
    }

    public INDArray create(DataBuffer data, int[] shape, int[] stride, long offset) {
        return new NDArray(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public INDArray create(List<INDArray> list, int[] shape) {
        return new NDArray(list, shape, Nd4j.getStrides((int[])shape));
    }

    public INDArray create(List<INDArray> list, long[] shape) {
        return new NDArray(list, shape, Nd4j.getStrides((long[])shape));
    }

    public INDArray empty(DataType type) {
        long extras = ArrayOptionsHelper.setOptionBit((long)0L, (ArrayType)ArrayType.EMPTY);
        extras = ArrayOptionsHelper.setOptionBit((long)extras, (DataType)type);
        Pair shape = Nd4j.getShapeInfoProvider().createShapeInformation(new long[0], new long[0], 1L, 'c', extras);
        return new NDArray(null, (LongBuffer)((Object)shape.getFirst()), (long[])shape.getSecond());
    }

    public INDArray create(float[][] floats) {
        return new NDArray(floats);
    }

    public INDArray create(float[][] data, char ordering) {
        return new NDArray(data, ordering);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        return new NDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(DataBuffer buffer, int[] shape, long offset) {
        return new NDArray(buffer, shape, Nd4j.getStrides((int[])shape), offset);
    }

    public INDArray create(float[] data, int[] shape, long offset) {
        return new NDArray(data, shape, offset);
    }

    public INDArray toFlattened(char order2, Collection<INDArray> matrices) {
        Preconditions.checkArgument((matrices.size() > 0 ? 1 : 0) != 0, (String)"toFlattened expects > 0 operands");
        return Nd4j.exec((CustomOp)new Flatten(order2, matrices.toArray(new INDArray[matrices.size()])))[0];
    }

    public INDArray[] tear(INDArray tensor, int ... dimensions) {
        if (tensor.isCompressed()) {
            Nd4j.getCompressor().decompressi(tensor);
        }
        Arrays.sort(dimensions);
        Pair tadBuffers = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(tensor, dimensions);
        long tadLength = 1L;
        long[] shape = new long[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            tadLength *= tensor.shape()[dimensions[i]];
            shape[i] = tensor.shape()[dimensions[i]];
        }
        int numTads = (int)(tensor.length() / tadLength);
        INDArray[] result = new INDArray[numTads];
        PointerPointer targets = new PointerPointer((long)numTads);
        for (int x = 0; x < numTads; ++x) {
            result[x] = Nd4j.createUninitialized((long[])shape);
            targets.put((long)x, result[x].data().pointer());
        }
        this.nativeOps.tear(null, ((BaseCpuDataBuffer)tensor.data()).getOpaqueDataBuffer(), (LongPointer)tensor.shapeInfoDataBuffer().pointer(), null, targets, (LongPointer)result[0].shapeInfoDataBuffer().pointer(), (LongPointer)((DataBuffer)tadBuffers.getFirst()).pointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).pointer()));
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        return result;
    }

    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat == null || toConcat.length == 0) {
            throw new ND4JIllegalStateException("Can't concatenate 0 arrays");
        }
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        return Nd4j.exec((CustomOp)new Concat(dimension, toConcat))[0];
    }

    public INDArray specialConcat(int dimension, INDArray ... toConcat) {
        return this.concat(dimension, toConcat);
    }

    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return this.pullRows(source, sourceDimension, ArrayUtil.toLongArray((int[])indexes));
    }

    public INDArray pullRows(INDArray source, int sourceDimension, long[] indexes) {
        return this.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    public INDArray pullRows(INDArray source, int sourceDimension, long[] indexes, char order2) {
        long[] shape;
        if (indexes == null || indexes.length < 1) {
            throw new IllegalStateException("Indexes can't be null or zero-length");
        }
        if (sourceDimension == 1) {
            shape = new long[]{indexes.length, source.shape()[sourceDimension]};
        } else if (sourceDimension == 0) {
            shape = new long[]{source.shape()[sourceDimension], indexes.length};
        } else {
            throw new UnsupportedOperationException("2D input is expected");
        }
        return this.pullRows(source, Nd4j.createUninitialized((DataType)source.dataType(), (long[])shape, (char)order2), sourceDimension, indexes);
    }

    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order2) {
        return this.pullRows(source, sourceDimension, ArrayUtil.toLongArray((int[])indexes), order2);
    }

    public INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, int[] indexes) {
        return this.pullRows(source, destination, sourceDimension, ArrayUtil.toLongArray((int[])indexes));
    }

    public INDArray pullRows(INDArray source, INDArray destination, int sourceDimension, long[] indexes) {
        if (indexes == null || indexes.length < 1) {
            throw new IllegalStateException("Indexes can't be null or zero-length");
        }
        long[] shape = null;
        if (sourceDimension == 1) {
            shape = new long[]{indexes.length, source.shape()[sourceDimension]};
        } else if (sourceDimension == 0) {
            shape = new long[]{source.shape()[sourceDimension], indexes.length};
        } else {
            throw new UnsupportedOperationException("2D input is expected");
        }
        INDArray ret = destination;
        if (ret == null) {
            ret = Nd4j.createUninitialized((DataType)source.dataType(), (long[])shape, (char)this.order);
        } else if (!Arrays.equals(shape, destination.shape())) {
            throw new IllegalStateException("Cannot pull rows into destination array: expected destination array of shape " + Arrays.toString(shape) + " but got destination array of shape " + Arrays.toString(destination.shape()));
        }
        Nd4j.getCompressor().autoDecompress(source);
        PointerPointer dummy = new PointerPointer(new Pointer[]{null});
        TADManager tadManager = Nd4j.getExecutioner().getTADManager();
        Pair tadBuffers = tadManager.getTADOnlyShapeInfo(source, new int[]{sourceDimension});
        Pair zTadBuffers = tadManager.getTADOnlyShapeInfo(ret, new int[]{sourceDimension});
        Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
        Pointer zTadShapeInfo = ((DataBuffer)zTadBuffers.getFirst()).addressPointer();
        LongPointer pIndex = new LongPointer(indexes);
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer hostTadOffsets = offsets == null ? null : offsets.addressPointer();
        DataBuffer zOffsets = (DataBuffer)zTadBuffers.getSecond();
        Pointer zTadOffsets = zOffsets == null ? null : zOffsets.addressPointer();
        this.nativeOps.pullRows(dummy, ((BaseCpuDataBuffer)source.data()).getOpaqueDataBuffer(), (LongPointer)source.shapeInfoDataBuffer().addressPointer(), null, ((BaseCpuDataBuffer)ret.data()).getOpaqueDataBuffer(), (LongPointer)ret.shapeInfoDataBuffer().addressPointer(), null, (long)indexes.length, pIndex, (LongPointer)hostTadShapeInfo, (LongPointer)new LongPointerWrapper(hostTadOffsets), (LongPointer)zTadShapeInfo, (LongPointer)new LongPointerWrapper(zTadOffsets));
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        return ret;
    }

    public INDArray accumulate(INDArray target, INDArray ... arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        if (arrays.length == 1) {
            return target.addi(arrays[0]);
        }
        long len = target.length();
        PointerPointer dataPointers = new PointerPointer((long)arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            Nd4j.getCompressor().autoDecompress(arrays[i]);
            if (arrays[i].elementWiseStride() != 1) {
                throw new ND4JIllegalStateException("Native accumulation is applicable only to continuous INDArrays");
            }
            if (arrays[i].length() != len) {
                throw new ND4JIllegalStateException("All arrays should have equal length for accumulation");
            }
            dataPointers.put((long)i, arrays[i].data().addressPointer());
        }
        this.nativeOps.accumulate(null, dataPointers, (LongPointer)arrays[0].shapeInfoDataBuffer().addressPointer(), null, null, target.data().addressPointer(), (LongPointer)target.shapeInfoDataBuffer().addressPointer(), null, null, arrays.length, len);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        return target;
    }

    public INDArray average(INDArray target, INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        if (arrays.length == 1) {
            if (target == null) {
                return null;
            }
            return target.assign(arrays[0]);
        }
        long len = target != null ? target.length() : arrays[0].length();
        PointerPointer dataPointers = new PointerPointer((long)arrays.length);
        DataType firstType = arrays[0].dataType();
        for (int i = 0; i < arrays.length; ++i) {
            Nd4j.getCompressor().autoDecompress(arrays[i]);
            Preconditions.checkArgument((arrays[i].dataType() == firstType ? 1 : 0) != 0, (String)"All arrays must have the same data type");
            if (arrays[i].elementWiseStride() != 1) {
                throw new ND4JIllegalStateException("Native averaging is applicable only to continuous INDArrays");
            }
            if (arrays[i].length() != len) {
                throw new ND4JIllegalStateException("All arrays should have equal length for averaging");
            }
            dataPointers.put((long)i, arrays[i].data().addressPointer());
        }
        this.nativeOps.average(null, dataPointers, (LongPointer)arrays[0].shapeInfoDataBuffer().addressPointer(), null, null, target == null ? null : target.data().addressPointer(), target == null ? null : (LongPointer)target.shapeInfoDataBuffer().addressPointer(), null, null, arrays.length, len, true);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        return target;
    }

    public INDArray average(INDArray target, Collection<INDArray> arrays) {
        return this.average(target, arrays.toArray(new INDArray[0]));
    }

    public INDArray average(INDArray[] arrays) {
        if (arrays == null || arrays.length == 0) {
            throw new RuntimeException("Input arrays are missing");
        }
        INDArray ret = Nd4j.createUninitialized((DataType)arrays[0].dataType(), (long[])arrays[0].shape(), (char)arrays[0].ordering());
        return this.average(ret, arrays);
    }

    public INDArray average(Collection<INDArray> arrays) {
        return this.average(arrays.toArray(new INDArray[0]));
    }

    public void shuffle(INDArray array, Random rnd, int ... dimension) {
        this.shuffle(Collections.singletonList(array), rnd, dimension);
    }

    public void shuffle(Collection<INDArray> array, Random rnd, int ... dimension) {
        this.shuffle(new ArrayList<INDArray>(array), rnd, Collections.singletonList(dimension));
    }

    public void shuffle(List<INDArray> arrays, Random rnd, List<int[]> dimensions) {
        if (dimensions == null || dimensions.size() == 0) {
            throw new RuntimeException("Dimension can't be null or 0-length");
        }
        if (arrays == null || arrays.size() == 0) {
            throw new RuntimeException("No input arrays provided");
        }
        if (dimensions.size() > 1 && arrays.size() != dimensions.size()) {
            throw new IllegalStateException("Number of dimensions do not match number of arrays to shuffle");
        }
        INDArray zero = arrays.get(0);
        int tadLength = 1;
        if (zero.rank() > 1) {
            for (int i = 0; i < dimensions.get(0).length; ++i) {
                tadLength = (int)((long)tadLength * zero.shape()[dimensions.get(0)[i]]);
            }
        }
        long numTads = zero.length() / (long)tadLength;
        int[] map = ArrayUtil.buildInterleavedVector((Random)rnd, (int)((int)numTads));
        PointerPointer dataPointers = new PointerPointer((long)arrays.size());
        PointerPointer shapePointers = new PointerPointer((long)arrays.size());
        PointerPointer tadPointers = new PointerPointer((long)arrays.size());
        PointerPointer offsetPointers = new PointerPointer((long)arrays.size());
        PointerPointer dummy = new PointerPointer(new Pointer[]{null});
        ArrayList<Pair> list = new ArrayList<Pair>();
        TADManager tadManager = Nd4j.getExecutioner().getTADManager();
        IntPointer ptrMap = new IntPointer(map);
        long[] ptrs = new long[arrays.size()];
        for (int i = 0; i < arrays.size(); ++i) {
            INDArray array = arrays.get(i);
            Nd4j.getCompressor().autoDecompress(array);
            int[] dimension = dimensions.size() > 1 ? dimensions.get(i) : dimensions.get(0);
            Pair tadBuffers = tadManager.getTADOnlyShapeInfo(array, dimension);
            list.add(tadBuffers);
            Pointer hostTadShapeInfo = ((DataBuffer)tadBuffers.getFirst()).addressPointer();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            if (array.rank() != 1 && offsets.length() != numTads) {
                throw new ND4JIllegalStateException("Can't symmetrically shuffle arrays with non-equal number of TADs");
            }
            if (offsets == null) {
                throw new ND4JIllegalStateException("Offsets for shuffle can't be null");
            }
            dataPointers.put((long)i, array.data().addressPointer());
            shapePointers.put((long)i, array.shapeInfoDataBuffer().addressPointer());
            offsetPointers.put((long)i, offsets.addressPointer());
            tadPointers.put((long)i, ((DataBuffer)tadBuffers.getFirst()).addressPointer());
        }
        this.nativeOps.shuffle(dummy, dataPointers, shapePointers, null, null, dataPointers, shapePointers, null, null, arrays.size(), ptrMap, tadPointers, offsetPointers);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        dataPointers.address();
        shapePointers.address();
        tadPointers.address();
        offsetPointers.address();
    }

    public INDArray convertDataEx(DataTypeEx typeSrc, INDArray source, DataTypeEx typeDst) {
        if (source.isView()) {
            throw new UnsupportedOperationException("Impossible to compress View. Consider using dup() before. ");
        }
        DataBuffer buffer = this.convertDataEx(typeSrc, source.data(), typeDst);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        source.setData(buffer);
        if (buffer instanceof CompressedDataBuffer) {
            source.markAsCompressed(true);
        } else {
            source.markAsCompressed(false);
        }
        return source;
    }

    public DataBuffer convertDataEx(DataTypeEx typeSrc, DataBuffer source, DataTypeEx typeDst) {
        int elementSize = 0;
        if (typeDst.ordinal() <= 2) {
            elementSize = 1;
        } else if (typeDst.ordinal() <= 5) {
            elementSize = 2;
        } else if (typeDst.ordinal() == 6) {
            elementSize = 4;
        } else if (typeDst.ordinal() == 7) {
            elementSize = 8;
        } else {
            throw new UnsupportedOperationException("Unknown target TypeEx: " + typeDst.name());
        }
        DataBuffer buffer = null;
        if (CompressionUtils.goingToCompress((DataTypeEx)typeSrc, (DataTypeEx)typeDst)) {
            BytePointer pointer = new BytePointer(source.length() * (long)elementSize);
            CompressionDescriptor descriptor = new CompressionDescriptor(source, typeDst.name());
            descriptor.setCompressionType(CompressionType.LOSSY);
            descriptor.setCompressedLength(source.length() * (long)elementSize);
            buffer = new CompressedDataBuffer((Pointer)pointer, descriptor);
        } else {
            CompressedDataBuffer compressed = (CompressedDataBuffer)source;
            CompressionDescriptor descriptor = compressed.getCompressionDescriptor();
            buffer = Nd4j.createBuffer((long)descriptor.getNumberOfElements(), (boolean)true);
        }
        this.convertDataEx(typeSrc, source, typeDst, buffer);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        return buffer;
    }

    public void convertDataEx(DataTypeEx typeSrc, Pointer source, DataTypeEx typeDst, Pointer target, long length) {
        this.nativeOps.convertTypes(null, typeSrc.ordinal(), source, length, typeDst.ordinal(), target);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
    }

    public void convertDataEx(DataTypeEx typeSrc, Pointer source, DataTypeEx typeDst, DataBuffer buffer) {
        this.convertDataEx(typeSrc, source, typeDst, buffer.addressPointer(), buffer.length());
    }

    public void convertDataEx(DataTypeEx typeSrc, DataBuffer source, DataTypeEx typeDst, DataBuffer target) {
        this.convertDataEx(typeSrc, source.addressPointer(), typeDst, target.addressPointer(), target.length());
    }

    public INDArray sort(INDArray x, boolean descending) {
        if (x.isScalar()) {
            return x;
        }
        NativeOpsHolder.getInstance().getDeviceNativeOps().sort(null, x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, null, descending);
        return x;
    }

    public INDArray sort(INDArray x, boolean descending, int ... dimension) {
        if (x.isScalar()) {
            return x;
        }
        Arrays.sort(dimension);
        Pair tadBuffers = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(x, dimension);
        NativeOpsHolder.getInstance().getDeviceNativeOps().sortTad(null, x.data().addressPointer(), (LongPointer)x.shapeInfoDataBuffer().addressPointer(), null, null, (IntPointer)Nd4j.getConstantHandler().getConstantBuffer(dimension, DataType.INT).addressPointer(), dimension.length, (LongPointer)((DataBuffer)tadBuffers.getFirst()).addressPointer(), (LongPointer)new LongPointerWrapper(((DataBuffer)tadBuffers.getSecond()).addressPointer()), descending);
        return x;
    }

    public INDArray sortCooIndices(INDArray x) {
        throw new UnsupportedOperationException("Not an COO ndarray");
    }

    public INDArray create(Collection<String> strings, long[] shape, char order2) {
        Pair pairShape = Nd4j.getShapeInfoProvider().createShapeInformation(shape, order2, DataType.UTF8);
        Utf8Buffer buffer = new Utf8Buffer(strings);
        ArrayList<String> list = new ArrayList<String>(strings);
        return Nd4j.createArrayFromShapeBuffer((DataBuffer)buffer, (Pair)pairShape);
    }

    public INDArray create(DataType dataType, long[] shape, long[] paddings, long[] paddingOffsets, char ordering, MemoryWorkspace workspace) {
        return new NDArray(dataType, shape, paddings, paddingOffsets, ordering, workspace);
    }

    static {
        Nd4j.getBlasWrapper();
    }
}

