/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entity.io;

import java.util.Map;
import org.neo4j.ogm.entity.io.FieldWriter;
import org.neo4j.ogm.entity.io.PropertyReader;
import org.neo4j.ogm.entity.io.RelationalReader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;

public class FieldReader
implements RelationalReader,
PropertyReader {
    private final ClassInfo classInfo;
    private final FieldInfo fieldInfo;

    public FieldReader(ClassInfo classInfo, FieldInfo fieldInfo) {
        this.classInfo = classInfo;
        this.fieldInfo = fieldInfo;
    }

    @Override
    public Object read(Object instance) {
        return FieldWriter.read(this.classInfo.getField(this.fieldInfo), instance);
    }

    @Override
    public Object readProperty(Object instance) {
        if (this.fieldInfo.hasCompositeConverter()) {
            throw new IllegalStateException("The readComposite method should be used for fields with a CompositeAttributeConverter");
        }
        Object value = FieldWriter.read(this.classInfo.getField(this.fieldInfo), instance);
        if (this.fieldInfo.hasPropertyConverter()) {
            value = this.fieldInfo.getPropertyConverter().toGraphProperty(value);
        }
        return value;
    }

    @Override
    public Map<String, ?> readComposite(Object instance) {
        if (!this.fieldInfo.hasCompositeConverter()) {
            throw new IllegalStateException("readComposite should only be used when a field is annotated with a CompositeAttributeConverter");
        }
        Object value = FieldWriter.read(this.classInfo.getField(this.fieldInfo), instance);
        return this.fieldInfo.getCompositeConverter().toGraphProperties(value);
    }

    @Override
    public String relationshipType() {
        return this.fieldInfo.relationship();
    }

    @Override
    public String propertyName() {
        return this.fieldInfo.property();
    }

    @Override
    public boolean isComposite() {
        return this.fieldInfo.hasCompositeConverter();
    }

    @Override
    public String relationshipDirection() {
        AnnotationInfo relationshipAnnotation;
        ObjectAnnotations annotations = this.fieldInfo.getAnnotations();
        if (annotations != null && (relationshipAnnotation = annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("direction", "OUTGOING");
        }
        return "OUTGOING";
    }

    @Override
    public String typeDescriptor() {
        return this.fieldInfo.getTypeDescriptor();
    }
}

