/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Method;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotations.Labels;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.neo4j.ogm.utils.RelationshipUtils;

public class FieldInfo {
    private static final String primitives = "I,J,S,B,C,F,D,Z,[I,[J,[S,[B,[C,[F,[D,[Z";
    private static final String autoboxers = "Ljava/lang/Object;Ljava/lang/Character;Ljava/lang/Byte;Ljava/lang/Short;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Float;Ljava/lang/Double;Ljava/lang/Boolean;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Character;[Ljava/lang/Byte;[Ljava/lang/Short;[Ljava/lang/Integer;[Ljava/lang/Long;[Ljava/lang/Float;[Ljava/lang/Double;[Ljava/lang/Boolean;[Ljava/lang/String;";
    private final String name;
    private final String descriptor;
    private final String typeParameterDescriptor;
    private final ObjectAnnotations annotations;
    private AttributeConverter<?, ?> propertyConverter;
    private CompositeAttributeConverter<?> compositeConverter;
    private String descriptorClass;
    private Class descriptorClazz;

    public FieldInfo(String name, String descriptor, String typeParameterDescriptor, ObjectAnnotations annotations) {
        this.name = name;
        this.descriptor = descriptor;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        if (!this.annotations.isEmpty()) {
            Object converter = this.getAnnotations().getConverter();
            if (converter instanceof AttributeConverter) {
                this.setPropertyConverter((AttributeConverter)converter);
            } else if (converter instanceof CompositeAttributeConverter) {
                this.setCompositeConverter((CompositeAttributeConverter)converter);
            } else if (converter != null) {
                throw new IllegalStateException(String.format("The converter for field %s is neither an instance of AttributeConverter or CompositeAttributeConverter", this.name));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.persistableAsProperty()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Property")) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (!this.persistableAsProperty()) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.persistableAsProperty() && this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean persistableAsProperty() {
        boolean simple = primitives.contains(this.descriptor) || autoboxers.contains(this.descriptor) && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && autoboxers.contains(this.typeParameterDescriptor) || this.propertyConverter != null || this.compositeConverter != null;
        return simple;
    }

    public AttributeConverter getPropertyConverter() {
        return this.propertyConverter;
    }

    void setPropertyConverter(AttributeConverter<?, ?> propertyConverter) {
        if (this.propertyConverter == null && this.compositeConverter == null && propertyConverter != null) {
            this.propertyConverter = propertyConverter;
        }
    }

    public boolean hasPropertyConverter() {
        return this.propertyConverter != null;
    }

    public CompositeAttributeConverter getCompositeConverter() {
        return this.compositeConverter;
    }

    public void setCompositeConverter(CompositeAttributeConverter<?> converter) {
        if (this.propertyConverter == null && this.compositeConverter == null && converter != null) {
            this.compositeConverter = converter;
        }
    }

    public boolean hasCompositeConverter() {
        return this.compositeConverter != null;
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isIterable() {
        try {
            if (this.descriptorClazz == null) {
                String descriptorClass = this.getCollectionClassname();
                this.descriptorClazz = MetaDataClassLoader.loadClass((String)descriptorClass);
            }
            if (Iterable.class.isAssignableFrom(this.descriptorClazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.typeParameterDescriptor != null && this.typeParameterDescriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "L" + iface.getName().replace(".", "/") + ";";
                if (this.typeParameterDescriptor == null || !this.typeParameterDescriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "[L" + type.getName().replace(".", "/") + ";";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            for (Class<?> iface : type.getInterfaces()) {
                typeSignature = "[L" + iface.getName().replace(".", "/") + ";";
                if (this.descriptor == null || !this.descriptor.equals(typeSignature)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public String getCollectionClassname() {
        if (this.descriptorClass != null) {
            return this.descriptorClass;
        }
        String descriptorClass = this.descriptor.replace("/", ".");
        if (descriptorClass.startsWith("L")) {
            descriptorClass = descriptorClass.substring(1, descriptorClass.length() - 1);
        }
        this.descriptorClass = descriptorClass;
        return descriptorClass;
    }

    public boolean isScalar() {
        return !this.isIterable() && !this.isArray();
    }

    public boolean isLabelField() {
        return this.getAnnotations().get("org.neo4j.ogm.annotation.Labels") != null || this.getAnnotations().get(Labels.CLASS) != null;
    }

    public boolean isArray() {
        return this.descriptor.startsWith("[");
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public String getTypeDescriptor() {
        if (!this.isIterable() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }

    public Class<?> convertedType() {
        if (this.hasPropertyConverter() || this.hasCompositeConverter()) {
            Class<?> converterClass = this.hasPropertyConverter() ? this.getPropertyConverter().getClass() : this.getCompositeConverter().getClass();
            String methodName = this.hasPropertyConverter() ? "toGraphProperty" : "toGraphProperties";
            try {
                for (Method method : converterClass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public boolean isConstraint() {
        AnnotationInfo indexAnnotation = this.getAnnotations().get(Index.class.getCanonicalName());
        return indexAnnotation != null && indexAnnotation.get("unique", "false").equals("true");
    }
}

