/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Collection;
import java.util.Collections;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.TypesUtil;

public class NodeDeleteStatements
implements DeleteStatements {
    @Override
    public CypherQuery delete(Long id) {
        return new DefaultRowModelRequest("MATCH (n) WHERE ID(n) = { id } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n", Utils.map("id", id));
    }

    @Override
    public CypherQuery delete(Collection<Long> ids) {
        return new DefaultRowModelRequest("MATCH (n) WHERE ID(n) in { ids } OPTIONAL MATCH (n)-[r0]-() DELETE r0, n", Utils.map("ids", ids));
    }

    @Override
    public CypherQuery deleteAll() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAllAndCount() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN COUNT(n)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAllAndList() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN ID(n)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery delete(String label) {
        return this.deleteAllByType(Collections.singleton(label));
    }

    @Override
    public CypherQuery deleteAllByType(Collection<String> labels) {
        String type = TypesUtil.labelsToType(labels);
        return new DefaultRowModelRequest(String.format("MATCH (n%s) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n", type), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAndCount(String label) {
        return new DefaultRowModelRequest(String.format("MATCH (n:`%s`) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN COUNT(n)", label), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAndList(String label) {
        return new DefaultRowModelRequest(String.format("MATCH (n:`%s`) OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN ID(n)", label), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery delete(String label, Iterable<Filter> filters) {
        return this.delete(Collections.singleton(label), filters);
    }

    @Override
    public CypherQuery delete(Collection<String> label, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(TypesUtil.labelsToType(label), filters);
        query.setReturnClause(" OPTIONAL MATCH (n)-[r0]-() DELETE r0, n");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery deleteAndCount(String label, Iterable<Filter> filters) {
        return this.deleteAndCount(Collections.singleton(label), filters);
    }

    @Override
    public CypherQuery deleteAndCount(Collection<String> label, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(TypesUtil.labelsToType(label), filters);
        query.setReturnClause(" OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN COUNT(n)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery deleteAndList(String label, Iterable<Filter> filters) {
        return this.deleteAndList(Collections.singleton(label), filters);
    }

    @Override
    public CypherQuery deleteAndList(Collection<String> labels, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildNodeQuery(TypesUtil.labelsToType(labels), filters);
        query.setReturnClause(" OPTIONAL MATCH (n)-[r0]-() DELETE r0, n RETURN ID(n)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }
}

