/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Collection;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.cypher.query.DefaultRowModelRequest;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.FilteredQuery;
import org.neo4j.ogm.session.request.FilteredQueryBuilder;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.request.strategy.impl.TypesUtil;

public class RelationshipDeleteStatements
implements DeleteStatements {
    @Override
    public CypherQuery delete(Long id) {
        return new DefaultRowModelRequest("MATCH (n)-[r0]->() WHERE ID(r0) = { id } DELETE r0", Utils.map("id", id));
    }

    @Override
    public CypherQuery delete(Collection<Long> ids) {
        return new DefaultRowModelRequest("MATCH (n)-[r0]->() WHERE ID(r0) IN { ids } DELETE r0", Utils.map("ids", ids));
    }

    @Override
    public CypherQuery deleteAll() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAllAndCount() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0 RETURN COUNT(r0)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAllAndList() {
        return new DefaultRowModelRequest("MATCH (n) OPTIONAL MATCH (n)-[r0]-() DELETE r0 RETURN ID(r0)", Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery delete(String type) {
        return new DefaultRowModelRequest(String.format("MATCH (n)-[r0:`%s`]-() DELETE r0", type), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAllByType(Collection<String> labels) {
        TypesUtil.checkSingleType(labels);
        return this.delete(labels.iterator().next());
    }

    @Override
    public CypherQuery deleteAndCount(String type) {
        return new DefaultRowModelRequest(String.format("MATCH (n)-[r0:`%s`]-() DELETE r0 RETURN COUNT(r0)", type), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery deleteAndList(String type) {
        return new DefaultRowModelRequest(String.format("MATCH (n)-[r0:`%s`]-() DELETE r0 RETURN ID(r0)", type), Utils.map(new Object[0]));
    }

    @Override
    public CypherQuery delete(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" DELETE r0");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery delete(Collection<String> labels, Iterable<Filter> filters) {
        TypesUtil.checkSingleType(labels);
        return this.delete(labels.iterator().next(), filters);
    }

    @Override
    public CypherQuery deleteAndCount(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" DELETE r0 RETURN COUNT(r0)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery deleteAndCount(Collection<String> labels, Iterable<Filter> filters) {
        TypesUtil.checkSingleType(labels);
        return this.deleteAndCount(labels.iterator().next(), filters);
    }

    @Override
    public CypherQuery deleteAndList(String type, Iterable<Filter> filters) {
        FilteredQuery query = FilteredQueryBuilder.buildRelationshipQuery(type, filters);
        query.setReturnClause(" DELETE r0 RETURN ID(r0)");
        return new DefaultRowModelRequest(query.statement(), query.parameters());
    }

    @Override
    public CypherQuery deleteAndList(Collection<String> labels, Iterable<Filter> filters) {
        return this.deleteAndList(labels.iterator().next(), filters);
    }
}

