/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat9.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.maven.common.config.AbstractWebapp;
import org.apache.tomcat.maven.common.run.EmbeddedRegistry;
import org.apache.tomcat.maven.common.run.ExternalRepositoriesReloadableWebappLoader;
import org.apache.tomcat.maven.plugin.tomcat9.AbstractTomcat9Mojo;
import org.apache.tomcat.maven.plugin.tomcat9.run.ExtendedTomcat;
import org.apache.tomcat.maven.plugin.tomcat9.run.Webapp;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractRunMojo
extends AbstractTomcat9Mojo {
    @Component
    protected ArtifactFactory factory;
    @Component
    protected ArtifactResolver resolver;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="tomcat.useSeparateTomcatClassLoader", defaultValue="false")
    protected boolean useSeparateTomcatClassLoader;
    @Parameter(property="maven.tomcat.contextReloadable", defaultValue="false")
    protected boolean contextReloadable;
    @Parameter(property="maven.tomcat.backgroundProcessorDelay", defaultValue="-1")
    protected int backgroundProcessorDelay = -1;
    @Parameter(property="maven.tomcat.contextFile")
    protected File contextFile;
    @Parameter(property="maven.tomcat.skip", defaultValue="false")
    protected boolean skip;
    @Parameter
    protected String classLoaderClass;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="maven.tomcat.propertiesPortFilePath")
    protected String propertiesPortFilePath;
    @Parameter(property="maven.tomcat.hostName", defaultValue="localhost")
    protected String hostName;
    @Parameter
    protected String[] aliases;
    @Parameter(property="maven.tomcat.https.clientAuth", defaultValue="false")
    protected String clientAuth = "false";
    @Component(role=MavenFileFilter.class, hint="default")
    protected MavenFileFilter mavenFileFilter;
    @Parameter(property="maven.tomcat.jarScan.allDirectories", defaultValue="true")
    protected boolean jarScanAllDirectories = true;
    @Parameter(property="maven.tomcat.useBodyEncodingForURI", defaultValue="false")
    protected boolean useBodyEncodingForURI;
    @Parameter
    protected String trustManagerClassName;
    @Parameter
    protected String trustMaxCertLength;
    @Parameter
    protected String truststoreAlgorithm;
    @Parameter
    protected String truststoreFile;
    @Parameter
    protected String truststorePass;
    @Parameter
    protected String truststoreProvider;
    @Parameter
    protected String truststoreType;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project.build.directory}/tomcat")
    private File configurationDir;
    @Parameter(property="maven.tomcat.port", defaultValue="8080")
    private int port;
    @Parameter(property="maven.tomcat.address")
    private String address;
    @Parameter(property="maven.tomcat.ajp.port", defaultValue="0")
    private int ajpPort;
    @Parameter(property="maven.tomcat.ajp.protocol", defaultValue="org.apache.coyote.ajp.AjpProtocol")
    private String ajpProtocol;
    @Parameter(property="maven.tomcat.httpsPort", defaultValue="0")
    private int httpsPort;
    @Parameter(property="maven.tomcat.maxPostSize", defaultValue="2097152")
    private int maxPostSize;
    @Parameter(property="maven.tomcat.uriEncoding", defaultValue="UTF-8")
    private String uriEncoding;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter(property="maven.tomcat.additionalConfigFilesDir", defaultValue="${basedir}/src/main/tomcatconf")
    private File additionalConfigFilesDir;
    @Parameter(property="maven.tomcat.serverXml")
    private File serverXml;
    @Parameter(property="maven.tomcat.webXml")
    private File tomcatWebXml;
    @Parameter(property="maven.tomcat.fork", defaultValue="false")
    private boolean fork;
    @Parameter(property="maven.tomcat.addContextWarDependencies", defaultValue="false")
    private boolean addContextWarDependencies;
    @Component
    private ArchiverManager archiverManager;
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="tomcat.ignorePackaging", defaultValue="false")
    private boolean ignorePackaging;
    @Parameter
    private String keystoreFile;
    @Parameter
    private String keystorePass;
    @Parameter(defaultValue="JKS")
    private String keystoreType;
    @Parameter(property="maven.tomcat.useNaming", defaultValue="true")
    private boolean useNaming;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/META-INF/context.xml", readonly=true)
    private File defaultContextFile;
    @Parameter(property="maven.tomcat.protocol", defaultValue="HTTP/1.1")
    private String protocol;
    @Parameter(property="maven.tomcat.tomcatUsers.file")
    private File tomcatUsers;
    @Parameter(property="maven.tomcat.tomcatLogging.file")
    private File tomcatLoggingFile;
    @Parameter
    private List<Webapp> webapps;
    @Parameter(property="maven.tomcat.staticContextPath", defaultValue="/")
    private String staticContextPath;
    @Parameter(property="maven.tomcat.staticContextDocbase")
    private String staticContextDocbase;
    private ClassRealm tomcatRealm;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip execution");
            return;
        }
        if (!this.isWar() && !this.addContextWarDependencies) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.nonWar"));
            return;
        }
        ClassLoader originalClassLoader = null;
        if (this.useSeparateTomcatClassLoader) {
            originalClassLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.runningWar", new Object[]{this.getWebappUrl()}));
            this.initConfiguration();
            this.startContainer();
            if (!this.fork) {
                this.waitIndefinitely();
            }
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
        catch (ServletException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("filtering issue: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    @Override
    protected String getPath() {
        return this.path;
    }

    protected void enhanceContext(Context context) throws MojoExecutionException {
    }

    protected Context createContext(Tomcat container) throws IOException, MojoExecutionException, ServletException {
        JarScanner jarScanner;
        String contextPath = this.getPath();
        String baseDir = this.getDocBase().getAbsolutePath();
        File overriddenContextFile = this.getContextFile();
        StandardContext standardContext = null;
        if (overriddenContextFile != null && overriddenContextFile.exists()) {
            this.getLog().info((CharSequence)("Using dynamic context configuration file: " + overriddenContextFile.getAbsolutePath()));
            standardContext = this.parseContextFile(overriddenContextFile);
        } else if (this.defaultContextFile.exists()) {
            this.getLog().info((CharSequence)("Using default context configuration file: " + this.defaultContextFile.getAbsolutePath()));
            standardContext = this.parseContextFile(this.defaultContextFile);
        }
        if (standardContext != null) {
            if (standardContext.getPath() != null) {
                contextPath = standardContext.getPath();
            }
            if (standardContext.getDocBase() != null) {
                baseDir = standardContext.getDocBase();
            }
        }
        contextPath = "/".equals(contextPath) ? "" : contextPath;
        this.getLog().info((CharSequence)("create webapp with contextPath: " + contextPath));
        Context context = container.addWebapp(contextPath, baseDir);
        StandardRoot root = new StandardRoot(context);
        context.setResources((WebResourceRoot)root);
        if (this.useSeparateTomcatClassLoader) {
            context.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
        }
        this.enhanceContext(context);
        WebappLoader loader = this.createWebappLoader();
        context.setLoader((Loader)loader);
        if (overriddenContextFile != null) {
            context.setConfigFile(overriddenContextFile.toURI().toURL());
        } else if (this.defaultContextFile.exists()) {
            context.setConfigFile(this.defaultContextFile.toURI().toURL());
        }
        if (this.classLoaderClass != null) {
            loader.setLoaderClass(this.classLoaderClass);
        }
        if ((jarScanner = context.getJarScanner()) instanceof StandardJarScanner) {
            ((StandardJarScanner)jarScanner).setScanAllDirectories(this.jarScanAllDirectories);
        }
        return context;
    }

    protected StandardContext parseContextFile(File file) throws MojoExecutionException {
        try {
            StandardContext standardContext = new StandardContext();
            XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(new FileInputStream(file));
            int tag = reader.next();
            while (true) {
                if (tag == 1 && StringUtils.equals((String)"Context", (String)reader.getLocalName())) {
                    String docBase;
                    String path = reader.getAttributeValue(null, "path");
                    if (StringUtils.isNotBlank((String)path)) {
                        standardContext.setPath(path);
                    }
                    if (StringUtils.isNotBlank((String)(docBase = reader.getAttributeValue(null, "docBase")))) {
                        standardContext.setDocBase(docBase);
                    }
                }
                if (!reader.hasNext()) break;
                tag = reader.next();
            }
            return standardContext;
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        if (this.useSeparateTomcatClassLoader) {
            if (this.isContextReloadable()) {
                return new ExternalRepositoriesReloadableWebappLoader((ClassLoader)this.getTomcatClassLoader(), this.getLog());
            }
            return new WebappLoader((ClassLoader)this.getTomcatClassLoader());
        }
        if (this.isContextReloadable()) {
            return new ExternalRepositoriesReloadableWebappLoader(Thread.currentThread().getContextClassLoader(), this.getLog());
        }
        return new WebappLoader(Thread.currentThread().getContextClassLoader());
    }

    protected boolean isContextReloadable() throws MojoExecutionException {
        if (this.contextReloadable || this.backgroundProcessorDelay > 0) {
            return true;
        }
        boolean reloadable = false;
        try {
            if (this.contextFile != null && this.contextFile.exists()) {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document contextDoc = builder.parse(this.contextFile);
                contextDoc.getDocumentElement().normalize();
                NamedNodeMap nodeMap = contextDoc.getDocumentElement().getAttributes();
                Node reloadableAttribute = nodeMap.getNamedItem("reloadable");
                reloadable = reloadableAttribute != null ? Boolean.valueOf(reloadableAttribute.getNodeValue()) : false;
            }
            this.getLog().debug((CharSequence)("context reloadable: " + reloadable));
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            this.getLog().error((CharSequence)"Could not configure XML parser", (Throwable)pce);
        }
        catch (SAXException se) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)se);
        }
        return reloadable;
    }

    protected abstract File getDocBase() throws IOException;

    protected abstract File getContextFile() throws MojoExecutionException;

    protected boolean isWar() {
        return "war".equals(this.packaging) || this.ignorePackaging;
    }

    private URL getWebappUrl() throws MalformedURLException {
        return new URL("http", "localhost", this.port, this.getPath());
    }

    private void initConfiguration() throws IOException, MojoExecutionException, MavenFilteringException {
        if (this.configurationDir.exists()) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.usingConfiguration", new Object[]{this.configurationDir}));
        } else {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.creatingConfiguration", new Object[]{this.configurationDir}));
            this.configurationDir.mkdirs();
            File confDir = new File(this.configurationDir, "conf");
            confDir.mkdir();
            if (this.tomcatLoggingFile != null) {
                FileUtils.copyFile((File)this.tomcatLoggingFile, (File)new File(confDir, "logging.properties"));
            } else {
                this.copyFile("/conf/logging.properties", new File(confDir, "logging.properties"));
            }
            this.copyFile("/conf/catalina.properties", new File(confDir, "catalina.properties"));
            if (this.tomcatWebXml != null) {
                if (!this.tomcatWebXml.exists()) {
                    throw new MojoExecutionException(" tomcatWebXml " + this.tomcatWebXml.getPath() + " not exists");
                }
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest();
                mavenFileFilterRequest.setFrom(this.tomcatWebXml);
                mavenFileFilterRequest.setTo(new File(confDir, "web.xml"));
                mavenFileFilterRequest.setMavenProject(this.project);
                mavenFileFilterRequest.setMavenSession(this.session);
                mavenFileFilterRequest.setFiltering(true);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
            } else {
                this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            }
            File logDir = new File(this.configurationDir, "logs");
            logDir.mkdir();
            File webappsDir = new File(this.configurationDir, "webapps");
            webappsDir.mkdir();
            if (this.additionalConfigFilesDir != null && this.additionalConfigFilesDir.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.addDefaultExcludes();
                scanner.setBasedir(this.additionalConfigFilesDir.getPath());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null && files.length > 0) {
                    this.getLog().info((CharSequence)"Coping additional tomcat config files");
                    for (int i = 0; i < files.length; ++i) {
                        File file = new File(this.additionalConfigFilesDir, files[i]);
                        this.getLog().info((CharSequence)(" copy " + file.getName()));
                        FileUtils.copyFileToDirectory((File)file, (File)confDir);
                    }
                }
            }
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer() throws IOException, LifecycleException, MojoExecutionException, ServletException {
        block38: {
            String previousCatalinaBase = System.getProperty("catalina.base");
            try {
                System.setProperty("java.awt.headless", "true");
                this.setupSystemProperties();
                System.setProperty("catalina.base", this.configurationDir.getAbsolutePath());
                if (this.serverXml != null) {
                    if (!this.serverXml.exists()) {
                        throw new MojoExecutionException(this.serverXml.getPath() + " not exists");
                    }
                    Catalina container = new Catalina();
                    if (this.useSeparateTomcatClassLoader) {
                        Thread.currentThread().setContextClassLoader((ClassLoader)this.getTomcatClassLoader());
                        container.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
                    }
                    container.setUseNaming(this.useNaming);
                    container.setConfigFile(this.serverXml.getAbsolutePath());
                    container.start();
                    EmbeddedRegistry.getInstance().register((Object)container);
                    break block38;
                }
                System.setProperty("java.util.logging.manager", "org.apache.juli.ClassLoaderLogManager");
                System.setProperty("java.util.logging.config.file", new File(this.configurationDir, "conf/logging.properties").toString());
                CatalinaProperties.getProperty((String)"foo");
                ExtendedTomcat embeddedTomcat = new ExtendedTomcat(this.configurationDir);
                embeddedTomcat.setBaseDir(this.configurationDir.getAbsolutePath());
                MemoryRealm memoryRealm = new MemoryRealm();
                if (this.tomcatUsers != null) {
                    if (!this.tomcatUsers.exists()) {
                        throw new MojoExecutionException(" tomcatUsers " + this.tomcatUsers.getPath() + " not exists");
                    }
                    this.getLog().info((CharSequence)("use tomcat-users.xml from " + this.tomcatUsers.getAbsolutePath()));
                    memoryRealm.setPathname(this.tomcatUsers.getAbsolutePath());
                }
                embeddedTomcat.getEngine().setRealm((Realm)memoryRealm);
                Context ctx = this.createContext(embeddedTomcat);
                if (this.useNaming) {
                    embeddedTomcat.enableNaming();
                }
                embeddedTomcat.getHost().setAppBase(new File(this.configurationDir, "webapps").getAbsolutePath());
                if (this.hostName != null) {
                    embeddedTomcat.getHost().setName(this.hostName);
                }
                if (this.aliases != null) {
                    for (String alias : this.aliases) {
                        embeddedTomcat.getHost().addAlias(alias);
                    }
                }
                this.createStaticContext(embeddedTomcat, ctx, embeddedTomcat.getHost());
                Connector connector = new Connector(this.protocol);
                connector.setPort(this.port);
                connector.setMaxPostSize(this.maxPostSize);
                if (this.httpsPort > 0) {
                    connector.setRedirectPort(this.httpsPort);
                }
                if (this.address != null) {
                    connector.setProperty("address", this.address);
                }
                connector.setURIEncoding(this.uriEncoding);
                connector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                embeddedTomcat.getService().addConnector(connector);
                embeddedTomcat.setConnector(connector);
                AccessLogValve alv = new AccessLogValve();
                alv.setDirectory(new File(this.configurationDir, "logs").getAbsolutePath());
                alv.setPattern("%h %l %u %t \"%r\" %s %b %I %D");
                embeddedTomcat.getHost().getPipeline().addValve((Valve)alv);
                Connector httpsConnector = null;
                if (this.httpsPort > 0) {
                    httpsConnector = new Connector(this.protocol);
                    httpsConnector.setPort(this.httpsPort);
                    httpsConnector.setMaxPostSize(this.maxPostSize);
                    httpsConnector.setSecure(true);
                    httpsConnector.setProperty("SSLEnabled", "true");
                    httpsConnector.setProperty("sslProtocol", "TLS");
                    if (this.keystoreFile != null) {
                        httpsConnector.setProperty("keystoreFile", this.keystoreFile);
                    }
                    if (this.keystorePass != null) {
                        httpsConnector.setProperty("keystorePass", this.keystorePass);
                    }
                    if (this.keystoreType != null) {
                        httpsConnector.setProperty("keystoreType", this.keystoreType);
                    }
                    if (this.trustManagerClassName != null) {
                        httpsConnector.setProperty("trustManagerClassName", this.trustManagerClassName);
                    }
                    if (this.trustMaxCertLength != null) {
                        httpsConnector.setProperty("trustMaxCertLength", this.trustMaxCertLength);
                    }
                    if (this.truststoreAlgorithm != null) {
                        httpsConnector.setProperty("truststoreAlgorithm", this.truststoreAlgorithm);
                    }
                    if (this.truststoreFile != null) {
                        httpsConnector.setProperty("truststoreFile", this.truststoreFile);
                    }
                    if (this.truststorePass != null) {
                        httpsConnector.setProperty("truststorePass", this.truststorePass);
                    }
                    if (this.truststoreProvider != null) {
                        httpsConnector.setProperty("truststoreProvider", this.truststoreProvider);
                    }
                    if (this.truststoreType != null) {
                        httpsConnector.setProperty("truststoreType", this.truststoreType);
                    }
                    httpsConnector.setProperty("clientAuth", this.clientAuth);
                    httpsConnector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                    if (this.address != null) {
                        httpsConnector.setProperty("address", this.address);
                    }
                    embeddedTomcat.getEngine().getService().addConnector(httpsConnector);
                }
                Connector ajpConnector = null;
                if (this.ajpPort > 0) {
                    ajpConnector = new Connector(this.ajpProtocol);
                    ajpConnector.setPort(this.ajpPort);
                    ajpConnector.setURIEncoding(this.uriEncoding);
                    ajpConnector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                    if (this.address != null) {
                        ajpConnector.setProperty("address", this.address);
                    }
                    embeddedTomcat.getEngine().getService().addConnector(ajpConnector);
                }
                if (this.addContextWarDependencies || !this.getAdditionalWebapps().isEmpty()) {
                    this.createDependencyContexts(embeddedTomcat);
                }
                if (this.useSeparateTomcatClassLoader) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.getTomcatClassLoader());
                    embeddedTomcat.getEngine().setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
                }
                embeddedTomcat.start();
                Properties portProperties = new Properties();
                portProperties.put("tomcat.maven.http.port", Integer.toString(connector.getLocalPort()));
                this.session.getExecutionProperties().put("tomcat.maven.http.port", Integer.toString(connector.getLocalPort()));
                System.setProperty("tomcat.maven.http.port", Integer.toString(connector.getLocalPort()));
                if (httpsConnector != null) {
                    this.session.getExecutionProperties().put("tomcat.maven.https.port", Integer.toString(httpsConnector.getLocalPort()));
                    portProperties.put("tomcat.maven.https.port", Integer.toString(httpsConnector.getLocalPort()));
                    System.setProperty("tomcat.maven.https.port", Integer.toString(httpsConnector.getLocalPort()));
                }
                if (ajpConnector != null) {
                    this.session.getExecutionProperties().put("tomcat.maven.ajp.port", Integer.toString(ajpConnector.getLocalPort()));
                    portProperties.put("tomcat.maven.ajp.port", Integer.toString(ajpConnector.getLocalPort()));
                    System.setProperty("tomcat.maven.ajp.port", Integer.toString(ajpConnector.getLocalPort()));
                }
                if (this.propertiesPortFilePath != null) {
                    File propertiesPortsFile = new File(this.propertiesPortFilePath);
                    if (propertiesPortsFile.exists()) {
                        propertiesPortsFile.delete();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(propertiesPortsFile);
                    try {
                        portProperties.store(fileOutputStream, "Apache Tomcat Maven plugin port used");
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    }
                }
                EmbeddedRegistry.getInstance().register((Object)embeddedTomcat);
            }
            finally {
                if (previousCatalinaBase != null) {
                    System.setProperty("catalina.base", previousCatalinaBase);
                }
            }
        }
    }

    private List<Webapp> getAdditionalWebapps() {
        if (this.webapps == null) {
            return Collections.emptyList();
        }
        return this.webapps;
    }

    protected ClassRealm getTomcatClassLoader() throws MojoExecutionException {
        if (this.tomcatRealm != null) {
            return this.tomcatRealm;
        }
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("tomcat", Thread.currentThread().getContextClassLoader());
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (pluginArtifact.getFile() == null) continue;
                root.addURL(pluginArtifact.getFile().toURI().toURL());
            }
            this.tomcatRealm = root;
            return root;
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public Set<Artifact> getProjectArtifacts() {
        return this.project.getArtifacts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void setupSystemProperties() {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            this.getLog().info((CharSequence)"setting SystemProperties:");
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    System.setProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
    }

    private Collection<Context> createDependencyContexts(Tomcat container) throws MojoExecutionException, MalformedURLException, ServletException, IOException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("tomcat");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"war".equals(artifact.getType()) || artifact.isOptional() || !filter.include(artifact)) continue;
            this.getLog().info((CharSequence)("Deploying dependency war : " + artifact.getArtifactId()));
            this.addContextFromArtifact(container, contexts, artifact, "/" + artifact.getArtifactId(), null, false);
        }
        for (AbstractWebapp abstractWebapp : this.getAdditionalWebapps()) {
            this.addContextFromWebapp(container, contexts, abstractWebapp);
        }
        return contexts;
    }

    private void addContextFromArtifact(Tomcat container, List<Context> contexts, Artifact artifact, String contextPath, File contextXml, boolean asWebApp) throws MojoExecutionException, ServletException, IOException {
        File contextFile;
        this.getLog().info((CharSequence)("Deploy warfile: " + String.valueOf(artifact.getFile()) + " to contextPath: " + contextPath));
        File webapps = new File(this.configurationDir, "webapps");
        File artifactWarDir = new File(webapps, artifact.getArtifactId());
        if (!artifactWarDir.exists()) {
            artifactWarDir.mkdir();
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
                unArchiver.setSourceFile(artifact.getFile());
                unArchiver.setDestDirectory(artifactWarDir);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException e) {
                this.getLog().error((Throwable)e);
                return;
            }
            catch (ArchiverException e) {
                this.getLog().error((Throwable)e);
                return;
            }
        }
        WebappLoader webappLoader = this.createWebappLoader();
        Context context = null;
        context = asWebApp ? container.addWebapp(contextPath, artifactWarDir.getAbsolutePath()) : container.addContext(contextPath, artifactWarDir.getAbsolutePath());
        context.setLoader((Loader)webappLoader);
        File file = contextFile = contextXml != null ? contextXml : this.getContextFile();
        if (contextFile != null) {
            context.setConfigFile(contextFile.toURI().toURL());
        }
        contexts.add(context);
    }

    private void addContextFromWebapp(Tomcat container, List<Context> contexts, AbstractWebapp webapp) throws MojoExecutionException, IOException {
        File contextFile;
        File artifactWarDir;
        File appFile = webapp.getAppFile();
        if (!appFile.exists()) {
            this.getLog().error((CharSequence)("\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728, " + appFile.getAbsolutePath()));
        }
        String artifactWarDirName = appFile.getName().replace(".war", "");
        String contextPath = webapp.getContextPath();
        if (contextPath == null) {
            contextPath = "/" + artifactWarDirName;
        } else if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        File contextXml = webapp.getContextFile();
        this.getLog().info((CharSequence)("Deploy webapp: " + appFile + " to contextPath: " + contextPath));
        if (!appFile.isDirectory()) {
            artifactWarDir = new File(new File(this.configurationDir, "webapps"), artifactWarDirName);
            if (!artifactWarDir.exists()) {
                artifactWarDir.mkdir();
                try {
                    UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
                    unArchiver.setSourceFile(appFile);
                    unArchiver.setDestDirectory(artifactWarDir);
                    unArchiver.extract();
                }
                catch (NoSuchArchiverException e) {
                    this.getLog().error((Throwable)e);
                    return;
                }
                catch (ArchiverException e) {
                    this.getLog().error((Throwable)e);
                    return;
                }
            }
        } else {
            artifactWarDir = appFile;
        }
        WebappLoader webappLoader = this.createWebappLoader();
        Context context = null;
        context = webapp.isAsWebapp() ? container.addWebapp(contextPath, artifactWarDir.getAbsolutePath()) : container.addContext(contextPath, artifactWarDir.getAbsolutePath());
        context.setLoader((Loader)webappLoader);
        File file = contextFile = contextXml != null ? contextXml : this.getContextFile();
        if (contextFile != null) {
            context.setConfigFile(contextFile.toURI().toURL());
        }
        contexts.add(context);
    }

    private void createStaticContext(Tomcat container, Context context, Host host) {
        if (this.staticContextDocbase != null) {
            Context staticContext = container.addContext(this.staticContextPath, this.staticContextDocbase);
            staticContext.setPrivileged(true);
            Wrapper servlet = context.createWrapper();
            servlet.setServletClass(DefaultServlet.class.getName());
            servlet.setName("staticContent");
            servlet.addMapping("/");
            staticContext.addChild((Container)servlet);
        }
    }

    protected Artifact getArtifact(AbstractWebapp additionalWebapp) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)additionalWebapp.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            this.getLog().warn((CharSequence)("fail to create versionRange from version: " + additionalWebapp.getVersion()), (Throwable)e);
            vr = VersionRange.createFromVersion((String)additionalWebapp.getVersion());
        }
        Artifact artifact = StringUtils.isEmpty((String)additionalWebapp.getClassifier()) ? this.factory.createDependencyArtifact(additionalWebapp.getGroupId(), additionalWebapp.getArtifactId(), vr, additionalWebapp.getType(), null, "compile") : this.factory.createDependencyArtifact(additionalWebapp.getGroupId(), additionalWebapp.getArtifactId(), vr, additionalWebapp.getType(), additionalWebapp.getClassifier(), "compile");
        try {
            this.resolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }
}

