/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat9.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tomcat.maven.plugin.tomcat9.run.AbstractExecWarMojo;
import org.apache.tomcat.maven.plugin.tomcat9.run.ExtraResource;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractStandaloneWarMojo
extends AbstractExecWarMojo {
    @Parameter(property="tomcat.jar.finalName", defaultValue="${project.artifactId}-${project.version}-standalone.war", required=true)
    protected String finalName;
    @Parameter(property="maven.tomcat.exec.war.attachArtifactClassifier", defaultValue="standalone", required=true)
    protected String attachArtifactClassifier;
    @Parameter(property="maven.tomcat.exec.war.attachArtifactType", defaultValue="war", required=true)
    protected String attachArtifactClassifierType;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"war".equals(this.project.getPackaging())) {
            throw new MojoFailureException("Pacakaging must be of type war for standalone-war goal.");
        }
        File warExecFile = new File(this.buildDirectory, this.finalName);
        if (warExecFile.exists()) {
            warExecFile.delete();
        }
        File execWarJar = new File(this.buildDirectory, this.finalName);
        FileOutputStream execWarJarOutputStream = null;
        ArchiveOutputStream os = null;
        File tmpPropertiesFile = null;
        File tmpManifestFile = null;
        FileOutputStream tmpPropertiesFileOutputStream = null;
        PrintWriter tmpManifestWriter = null;
        try {
            tmpPropertiesFile = new File(this.buildDirectory, "war-exec.properties");
            if (tmpPropertiesFile.exists()) {
                tmpPropertiesFile.delete();
            }
            tmpPropertiesFile.getParentFile().mkdirs();
            tmpManifestFile = new File(this.buildDirectory, "war-exec.manifest");
            if (tmpManifestFile.exists()) {
                tmpManifestFile.delete();
            }
            tmpPropertiesFileOutputStream = new FileOutputStream(tmpPropertiesFile);
            execWarJar.getParentFile().mkdirs();
            execWarJar.createNewFile();
            execWarJarOutputStream = new FileOutputStream(execWarJar);
            tmpManifestWriter = new PrintWriter(tmpManifestFile);
            Properties properties = new Properties();
            properties.put("generationTimestamp", Long.toString(System.currentTimeMillis()));
            properties.put("enableNaming", Boolean.toString(this.enableNaming));
            properties.put("accessLogValveFormat", this.accessLogValveFormat);
            properties.put("connectorhttpProtocol", this.connectorHttpProtocol);
            properties.put("codeSourceContextPath", this.path);
            os = new ArchiveStreamFactory().createArchiveOutputStream("jar", (OutputStream)execWarJarOutputStream);
            this.extractJarToArchive(new JarFile(this.projectArtifact.getFile()), os, null);
            if (this.serverXml != null && this.serverXml.exists()) {
                os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("conf/server.xml"));
                IOUtils.copy((InputStream)new FileInputStream(this.serverXml), (OutputStream)os);
                os.closeArchiveEntry();
                properties.put("useServerXml", Boolean.TRUE.toString());
            } else {
                properties.put("useServerXml", Boolean.FALSE.toString());
            }
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("conf/web.xml"));
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/conf/web.xml"), (OutputStream)os);
            os.closeArchiveEntry();
            properties.store(tmpPropertiesFileOutputStream, "created by Apache Tomcat Maven plugin");
            tmpPropertiesFileOutputStream.flush();
            tmpPropertiesFileOutputStream.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("tomcat.standalone.properties"));
            IOUtils.copy((InputStream)new FileInputStream(tmpPropertiesFile), (OutputStream)os);
            os.closeArchiveEntry();
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (!StringUtils.equals((String)"org.apache.tomcat", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.apache.tomcat.embed", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"org.eclipse.jdt.core.compiler", (String)pluginArtifact.getGroupId()) && !StringUtils.equals((String)"commons-cli", (String)pluginArtifact.getArtifactId()) && !StringUtils.equals((String)"tomcat9-war-runner", (String)pluginArtifact.getArtifactId())) continue;
                JarFile jarFile = new JarFile(pluginArtifact.getFile());
                this.extractJarToArchive(jarFile, os, null);
            }
            if (this.extraDependencies != null && !this.extraDependencies.isEmpty()) {
                for (Dependency dependency : this.extraDependencies) {
                    Object version = dependency.getVersion();
                    if (StringUtils.isEmpty((String)version)) {
                        version = this.findArtifactVersion(dependency);
                    }
                    if (StringUtils.isEmpty((String)version)) {
                        throw new MojoExecutionException("Dependency '" + dependency.getGroupId() + "':'" + dependency.getArtifactId() + "' does not have version specified");
                    }
                    Artifact artifact = this.artifactFactory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), (String)version, dependency.getScope(), dependency.getType());
                    this.artifactResolver.resolve(artifact, this.remoteRepos, this.local);
                    JarFile jarFile = new JarFile(artifact.getFile());
                    this.extractJarToArchive(jarFile, os, this.excludes);
                }
            }
            Manifest manifest = new Manifest();
            Manifest.Attribute mainClassAtt = new Manifest.Attribute();
            mainClassAtt.setName("Main-Class");
            mainClassAtt.setValue(this.mainClass);
            manifest.addConfiguredAttribute(mainClassAtt);
            manifest.write((Writer)tmpManifestWriter);
            tmpManifestWriter.flush();
            tmpManifestWriter.close();
            os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("META-INF/MANIFEST.MF"));
            IOUtils.copy((InputStream)new FileInputStream(tmpManifestFile), (OutputStream)os);
            os.closeArchiveEntry();
            if (this.attachArtifact) {
                this.projectHelper.attachArtifact(this.project, this.attachArtifactClassifierType, this.attachArtifactClassifier, execWarJar);
            }
            if (this.extraResources != null) {
                for (ExtraResource extraResource : this.extraResources) {
                    DirectoryScanner directoryScanner = new DirectoryScanner();
                    directoryScanner.setBasedir(extraResource.getDirectory());
                    directoryScanner.addDefaultExcludes();
                    directoryScanner.setExcludes(this.toStringArray(extraResource.getExcludes()));
                    directoryScanner.setIncludes(this.toStringArray(extraResource.getIncludes()));
                    directoryScanner.scan();
                    for (String includeFile : directoryScanner.getIncludedFiles()) {
                        this.getLog().debug((CharSequence)("include file:" + includeFile));
                        os.putArchiveEntry((ArchiveEntry)new JarArchiveEntry(includeFile));
                        IOUtils.copy((InputStream)new FileInputStream(new File(extraResource.getDirectory(), includeFile)), (OutputStream)os);
                        os.closeArchiveEntry();
                    }
                }
            }
            if (this.tomcatConfigurationFilesDirectory != null && this.tomcatConfigurationFilesDirectory.exists()) {
                String aConfigOutputDir = "conf/";
                this.copyDirectoryContentIntoArchive(this.tomcatConfigurationFilesDirectory, aConfigOutputDir, os);
            }
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
                }
                catch (ArchiveException e3) {
                    throw new MojoExecutionException(e3.getMessage(), (Exception)((Object)e3));
                }
                catch (ArtifactNotFoundException e4) {
                    throw new MojoExecutionException(e4.getMessage(), (Exception)((Object)e4));
                }
                catch (ArtifactResolutionException e5) {
                    throw new MojoExecutionException(e5.getMessage(), (Exception)((Object)e5));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(tmpManifestWriter);
                IOUtils.closeQuietly(execWarJarOutputStream);
                IOUtils.closeQuietly(tmpPropertiesFileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((Writer)tmpManifestWriter);
        IOUtils.closeQuietly((OutputStream)execWarJarOutputStream);
        IOUtils.closeQuietly((OutputStream)tmpPropertiesFileOutputStream);
    }
}

