/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat9.run;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResourceSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculator;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorRequest;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorResult;
import org.apache.tomcat.maven.common.run.TomcatRunException;
import org.apache.tomcat.maven.plugin.tomcat9.run.AbstractRunMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends AbstractRunMojo {
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${basedir}/src/main/webapp", property="tomcat.warSourceDirectory")
    private File warSourceDirectory;
    @Parameter(property="tomcat.delegate", defaultValue="true")
    private boolean delegate = true;
    @Component
    private ClassLoaderEntriesCalculator classLoaderEntriesCalculator;
    @Parameter(property="maven.tomcat.addWarDependenciesInClassloader", defaultValue="true")
    private boolean addWarDependenciesInClassloader;
    @Parameter(property="maven.tomcat.useTestClasspath", defaultValue="false")
    private boolean useTestClasspath;
    @Parameter(alias="additionalClassesDirs")
    private List<String> additionalClasspathDirs;

    private static File createTempDirectory(File baseTmpDirectory) throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()), baseTmpDirectory);
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public final File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    @Override
    protected File getDocBase() throws IOException {
        if (!this.warSourceDirectory.exists()) {
            final File tempDocBase = RunMojo.createTempDirectory(new File(this.project.getBuild().getDirectory()));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        FileUtils.deleteDirectory((File)tempDocBase);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return tempDocBase;
        }
        return this.warSourceDirectory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected File getContextFile() throws MojoExecutionException {
        StringWriter sw;
        FileWriter fw;
        FileReader fr;
        File temporaryContextFile;
        block8: {
            File sb2222222;
            temporaryContextFile = null;
            fr = null;
            fw = null;
            sw = new StringWriter();
            try {
                temporaryContextFile = File.createTempFile("tomcat-maven-plugin", "temp-ctx-file");
                temporaryContextFile.deleteOnExit();
                if (this.contextFile != null && this.contextFile.exists()) {
                    MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest();
                    mavenFileFilterRequest.setFrom(this.contextFile);
                    mavenFileFilterRequest.setTo(temporaryContextFile);
                    mavenFileFilterRequest.setMavenProject(this.project);
                    mavenFileFilterRequest.setMavenSession(this.session);
                    mavenFileFilterRequest.setFiltering(true);
                    this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                    fr = new FileReader(temporaryContextFile);
                    Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)fr);
                    xpp3Dom.setAttribute("backgroundProcessorDelay", Integer.toString(this.backgroundProcessorDelay));
                    xpp3Dom.setAttribute("reloadable", Boolean.toString(this.isContextReloadable()));
                    fw = new FileWriter(temporaryContextFile);
                    Xpp3DomWriter.write((Writer)fw, (Xpp3Dom)xpp3Dom);
                    Xpp3DomWriter.write((Writer)sw, (Xpp3Dom)xpp3Dom);
                    this.getLog().debug((CharSequence)(" generated context file " + sw.toString()));
                    break block8;
                }
                if (this.contextReloadable) {
                    StringBuilder sb2222222 = new StringBuilder("<Context ").append("backgroundProcessorDelay=\"").append(this.backgroundProcessorDelay).append("\"").append(" reloadable=\"" + this.isContextReloadable() + "\"/>");
                    this.getLog().debug((CharSequence)(" generated context file " + sb2222222.toString()));
                    fw = new FileWriter(temporaryContextFile);
                    fw.write(sb2222222.toString());
                    break block8;
                }
                sb2222222 = null;
            }
            catch (IOException e) {
                try {
                    this.getLog().error((CharSequence)("error creating fake context.xml : " + e.getMessage()), (Throwable)e);
                    throw new MojoExecutionException("error creating fake context.xml : " + e.getMessage(), (Exception)e);
                    catch (XmlPullParserException e2) {
                        this.getLog().error((CharSequence)("error creating fake context.xml : " + e2.getMessage()), (Throwable)e2);
                        throw new MojoExecutionException("error creating fake context.xml : " + e2.getMessage(), (Exception)((Object)e2));
                    }
                    catch (MavenFilteringException e3) {
                        this.getLog().error((CharSequence)("error filtering context.xml : " + e3.getMessage()), (Throwable)e3);
                        throw new MojoExecutionException("error filtering context.xml : " + e3.getMessage(), (Exception)((Object)e3));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fw);
                    IOUtil.close(fr);
                    IOUtil.close((Writer)sw);
                    throw throwable;
                }
            }
            IOUtil.close(fw);
            IOUtil.close(fr);
            IOUtil.close((Writer)sw);
            return sb2222222;
        }
        IOUtil.close((Writer)fw);
        IOUtil.close((Reader)fr);
        IOUtil.close((Writer)sw);
        return temporaryContextFile;
    }

    @Override
    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        WebappLoader loader = super.createWebappLoader();
        if (this.useSeparateTomcatClassLoader) {
            loader.setDelegate(this.delegate);
        }
        return loader;
    }

    @Override
    protected void enhanceContext(Context context) throws MojoExecutionException {
        super.enhanceContext(context);
        try {
            Xpp3Dom cfg;
            Xpp3Dom webResources;
            ClassLoaderEntriesCalculatorRequest request = new ClassLoaderEntriesCalculatorRequest().setDependencies(this.dependencies).setLog(this.getLog()).setMavenProject(this.project).setAddWarDependenciesInClassloader(this.addWarDependenciesInClassloader).setUseTestClassPath(this.useTestClasspath);
            ClassLoaderEntriesCalculatorResult classLoaderEntriesCalculatorResult = this.classLoaderEntriesCalculator.calculateClassPathEntries(request);
            List classLoaderEntries = classLoaderEntriesCalculatorResult.getClassPathEntries();
            final List tmpDirectories = classLoaderEntriesCalculatorResult.getTmpDirectories();
            List<String> jarPaths = this.extractJars(classLoaderEntries);
            for (String string : jarPaths) {
                File f = new File(string);
                if (!f.exists()) continue;
                this.getLog().debug((CharSequence)("Adding jar resource: " + f.getAbsolutePath()));
                FileResourceSet fileResourceSet = new FileResourceSet(context.getResources(), "/WEB-INF/lib/" + f.getName(), f.getAbsolutePath(), "/");
                context.getResources().addPostResources((WebResourceSet)fileResourceSet);
            }
            this.getLog().debug((CharSequence)("Adding classes resource: " + new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath()));
            DirResourceSet webinfClassesResources = new DirResourceSet(context.getResources(), "/WEB-INF/classes", new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath(), "/"){

                public WebResource getResource(String path) {
                    if ("/WEB-INF/classes/META-INF/beans.xml".equals(path)) {
                        RunMojo.this.getLog().info((CharSequence)"Rejecting request for /WEB-INF/classes/META-INF/beans.xml for Weld compatibility. beans.xml can be found at /WEB-INF/beans.xml");
                        return new EmptyResource(this.getRoot(), path);
                    }
                    if ("/WEB-INF/beans.xml".equals(path)) {
                        WebResource beans = super.getResource(path);
                        if (!beans.exists() && (beans = super.getResource("/WEB-INF/classes/META-INF/beans.xml")).exists()) {
                            RunMojo.this.getLog().info((CharSequence)"Returning /WEB-INF/classes/META-INF/beans.xml for request of /WEB-INF/beans.xml for Weld compatibility");
                        }
                        return beans;
                    }
                    return super.getResource(path);
                }
            };
            context.getResources().addPreResources((WebResourceSet)webinfClassesResources);
            for (String buildDirectory : classLoaderEntriesCalculatorResult.getBuildDirectories()) {
                if (buildDirectory.equals(this.project.getBuild().getOutputDirectory())) continue;
                File buildDirectoryFile = new File(buildDirectory);
                this.getLog().debug((CharSequence)("Adding additional classes resource: " + buildDirectoryFile.getAbsolutePath()));
                DirResourceSet otherClassesResources = new DirResourceSet(context.getResources(), "/WEB-INF/classes", buildDirectoryFile.getAbsolutePath(), "/");
                context.getResources().addPreResources((WebResourceSet)otherClassesResources);
            }
            Plugin plugin = (Plugin)this.project.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-war-plugin");
            if (plugin != null && plugin.getConfiguration() instanceof Xpp3Dom && (webResources = (cfg = (Xpp3Dom)plugin.getConfiguration()).getChild("webResources")) != null) {
                Xpp3Dom[] resources;
                for (Xpp3Dom resource : resources = webResources.getChildren("resource")) {
                    Xpp3Dom directoryNode = resource.getChild("directory");
                    if (directoryNode == null) continue;
                    String directory = directoryNode.getValue();
                    Xpp3Dom targetPathNode = resource.getChild("targetPath");
                    String targetPath = targetPathNode != null ? "/" + targetPathNode.getValue() : "/";
                    Xpp3Dom filtering = resource.getChild("filtering");
                    if (filtering != null && "true".equals(filtering.getValue())) {
                        this.getLog().warn((CharSequence)("Cannot support filtered web-resource, not adding: " + directory));
                        continue;
                    }
                    File directoryFile = directory.startsWith(File.separator) ? new File(directory) : new File(this.project.getBasedir(), directory);
                    DirResourceSet dirResourceSet = new DirResourceSet(context.getResources(), targetPath, directoryFile.getAbsolutePath(), "/");
                    dirResourceSet.setStaticOnly(true);
                    context.getResources().addPostResources((WebResourceSet)dirResourceSet);
                    this.getLog().debug((CharSequence)("Adding additional static resources at \"" + targetPath + "\": " + directoryFile.getAbsolutePath()));
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (File tmpDir : tmpDirectories) {
                        try {
                            FileUtils.deleteDirectory((File)tmpDir);
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (TomcatRunException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private List<String> extractJars(List<String> classLoaderEntries) throws MojoExecutionException {
        ArrayList<String> jarPaths = new ArrayList<String>();
        try {
            for (String classLoaderEntry : classLoaderEntries) {
                URI uri = new URI(classLoaderEntry);
                File file = new File(uri);
                if (file.isDirectory() || !StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".jar")) continue;
                jarPaths.add(file.getAbsolutePath());
            }
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return jarPaths;
    }
}

