/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader.javassist;

import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.classloader.javassist.ClassPathAdjuster;

class ClassPoolFactory {
    private UseClassPathAdjuster useClassPathAdjuster;

    ClassPoolFactory(UseClassPathAdjuster useClassPathAdjuster) {
        this.useClassPathAdjuster = useClassPathAdjuster;
    }

    ClassPool create() {
        ClassPool classPool = new ClassPool();
        classPool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        if (this.useClassPathAdjuster != null) {
            try {
                Class<? extends ClassPathAdjuster> value = this.useClassPathAdjuster.value();
                ClassPathAdjuster classPathAdjuster = value.newInstance();
                classPathAdjuster.adjustClassPath(classPool);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class path adjuster", e);
            }
        }
        return classPool;
    }
}

