/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.util.List;
import org.simpleframework.http.Address;
import org.simpleframework.http.Path;
import org.simpleframework.http.Query;
import org.simpleframework.http.message.HeaderConsumer;
import org.simpleframework.http.parse.AddressParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestConsumer
extends HeaderConsumer {
    protected AddressParser parser;
    protected String method;
    protected String target;
    protected int major;
    protected int minor;

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public Address getAddress() {
        if (this.parser == null) {
            this.parser = new AddressParser(this.target);
        }
        return this.parser;
    }

    @Override
    public Query getQuery() {
        return this.getAddress().getQuery();
    }

    @Override
    public Path getPath() {
        return this.getAddress().getPath();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public long getDate(String name) {
        return this.header.getDate(name);
    }

    @Override
    public int getInteger(String name) {
        return this.header.getInteger(name);
    }

    @Override
    public List<String> getNames() {
        return this.header.getNames();
    }

    @Override
    protected void process() {
        this.method();
        this.target();
        this.version();
        this.end();
        this.headers();
    }

    private void target() {
        Token token = new Token(this.array, this.pos, 0);
        while (this.pos < this.count) {
            if (this.white(this.array[this.pos])) {
                ++this.pos;
                break;
            }
            ++token.size;
            ++this.pos;
        }
        this.target = token.toString();
    }

    private void method() {
        Token token = new Token(this.array, this.pos, 0);
        while (this.pos < this.count) {
            if (this.white(this.array[this.pos])) {
                ++this.pos;
                break;
            }
            ++token.size;
            ++this.pos;
        }
        this.method = token.toString();
    }

    protected void version() {
        this.pos += 5;
        this.major();
        ++this.pos;
        this.minor();
    }

    private void major() {
        while (this.pos < this.count && this.digit(this.array[this.pos])) {
            this.major *= 10;
            this.major += this.array[this.pos];
            this.major -= 48;
            ++this.pos;
        }
    }

    private void minor() {
        while (this.pos < this.count && this.digit(this.array[this.pos])) {
            this.minor *= 10;
            this.minor += this.array[this.pos];
            this.minor -= 48;
            ++this.pos;
        }
    }

    protected boolean digit(byte octet) {
        return octet >= 48 && octet <= 57;
    }

    @Override
    public CharSequence getHeader() {
        return new Token(this.array, 0, this.count);
    }

    @Override
    public String toString() {
        return ((Object)this.getHeader()).toString();
    }

    private static class Token
    implements CharSequence {
        public byte[] array;
        public int size;
        public int off;

        private Token(byte[] array, int off, int size) {
            this.array = array;
            this.size = size;
            this.off = off;
        }

        public int length() {
            return this.size;
        }

        public char charAt(int index) {
            return (char)this.array[index];
        }

        public CharSequence subSequence(int start, int end) {
            return new Token(this.array, start, end - start);
        }

        public String toString() {
            return this.toString("UTF-8");
        }

        public String toString(String charset) {
            try {
                return new String(this.array, this.off, this.size, charset);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

