/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.transport.ByteCursor;

public abstract class UpdateConsumer
implements BodyConsumer {
    protected byte[] array;
    protected boolean finished;

    protected UpdateConsumer() {
        this(2048);
    }

    protected UpdateConsumer(int chunk) {
        this.array = new byte[chunk];
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void consume(ByteCursor cursor) throws IOException {
        int ready = cursor.ready();
        while (ready > 0) {
            int reset;
            int size = Math.min(ready, this.array.length);
            int count = cursor.read(this.array, 0, size);
            if (count > 0 && (reset = this.update(this.array, 0, count)) > 0) {
                cursor.reset(reset);
            }
            if (this.finished) {
                this.commit(cursor);
                break;
            }
            ready = cursor.ready();
        }
    }

    protected void commit(ByteCursor cursor) throws IOException {
        if (!this.finished) {
            throw new IOException("Consumer not finished");
        }
    }

    protected abstract int update(byte[] var1, int var2, int var3) throws IOException;
}

