/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.simpleframework.http.Path;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRouter
implements Router {
    private final Map<String, Service> registry;
    private final Service primary;

    public PathRouter(Map<String, Service> registry, Service primary) throws IOException {
        this.registry = registry;
        this.primary = primary;
    }

    @Override
    public Service route(Request request, Response response) {
        String token = request.getValue("Upgrade");
        if (token != null && token.equalsIgnoreCase("websocket")) {
            List<String> protocols = request.getValues("Sec-WebSocket-Protocol");
            String version = request.getValue("Sec-WebSocket-Version");
            Path path = request.getPath();
            String normal = path.getPath();
            if (version != null) {
                response.setValue("Sec-WebSocket-Version", version);
            }
            for (String protocol : protocols) {
                String original = response.getValue("Sec-WebSocket-Protocol");
                if (original != null) continue;
                response.setValue("Sec-WebSocket-Protocol", protocol);
            }
            Service service = this.registry.get(normal);
            if (service != null) {
                return service;
            }
            return this.primary;
        }
        return null;
    }
}

