/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.converter.JCLMatcher;
import org.slf4j.converter.PatternWrapper;

public abstract class AbstractMatcher {
    protected ArrayList<PatternWrapper> rules;
    protected boolean commentConversion = true;
    protected boolean blockComment = false;

    public static AbstractMatcher getMatcherImpl(int conversionType) {
        if (conversionType == 1) {
            return new JCLMatcher();
        }
        return null;
    }

    public void setCommentConversion(boolean commentConversion) {
        this.commentConversion = commentConversion;
    }

    public String replace(String text) {
        if (this.isTextConvertible(text)) {
            for (PatternWrapper patternWrapper : this.rules) {
                Pattern pattern = patternWrapper.getPattern();
                Matcher matcher = pattern.matcher(text);
                if (!matcher.matches()) continue;
                System.out.println("matching " + text);
                StringBuffer replacementBuffer = new StringBuffer();
                for (int group = 0; group <= matcher.groupCount(); ++group) {
                    String replacementText = patternWrapper.getReplacement(group);
                    if (replacementText != null) {
                        System.out.println("replacing group " + group + " : " + matcher.group(group) + " with " + replacementText);
                        replacementBuffer.append(replacementText);
                        continue;
                    }
                    if (group <= 0) continue;
                    replacementBuffer.append(matcher.group(group));
                }
                return replacementBuffer.toString();
            }
        }
        return text;
    }

    private boolean isTextConvertible(String text) {
        boolean isConvertible = true;
        if (text.trim().length() == 0) {
            isConvertible = false;
        } else if (this.commentConversion) {
            isConvertible = true;
        } else if (this.blockComment || text.startsWith("//")) {
            isConvertible = false;
        } else if (text.startsWith("/*")) {
            this.blockComment = true;
            isConvertible = false;
        }
        if (text.endsWith("*/")) {
            this.blockComment = false;
        }
        return isConvertible;
    }

    protected abstract void initRules();
}

