/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import org.slf4j.converter.AbstractMatcher;
import org.slf4j.converter.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    private List<File> javaFiles;
    private AbstractMatcher matcher;
    private Writer writer;
    private String source;
    private int conversionType;
    private boolean commentConversion;

    public static void main(String[] args) throws IOException {
        Converter converter = new Converter();
        if (args.length > 0) {
            converter.source = args[0];
        } else {
            JFileChooser selector = new JFileChooser();
            selector.setDialogTitle("Source folder selector");
            selector.setFileSelectionMode(1);
            int res = selector.showOpenDialog(null);
            if (res == 0) {
                File folder = selector.getSelectedFile();
                converter.source = folder.getAbsolutePath();
            } else {
                return;
            }
        }
        converter.conversionType = 1;
        if (converter.init()) {
            converter.convert(converter.javaFiles);
        }
    }

    public boolean init() throws IOException {
        this.matcher = AbstractMatcher.getMatcherImpl(this.conversionType);
        if (this.matcher == null) {
            return false;
        }
        this.matcher.setCommentConversion(this.commentConversion);
        this.writer = new Writer();
        File fileSource = new File(this.source);
        if (!fileSource.isDirectory()) {
            System.out.println("source path is not a valid source directory");
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("RUNNING CONVERTER WILL REPLACE JAVA FILES CONTAINED IN " + this.source + ", DO YOU WANT TO CONTINUE Y / N ?");
        String response = in.readLine();
        if (response.equalsIgnoreCase("N")) {
            return false;
        }
        this.selectFiles(fileSource);
        if (this.javaFiles.size() > 1000) {
            System.out.println("THERE IS " + this.javaFiles.size() + " FILES TO CONVERT, DO YOU WANT TO CONTINUE Y / N ?");
            if (response.equalsIgnoreCase("N")) {
                return false;
            }
        }
        return true;
    }

    private void delete(File fdest) {
        if (fdest.isDirectory()) {
            File[] files = fdest.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.delete(files[i]);
                }
            }
            fdest.delete();
        } else {
            fdest.delete();
        }
    }

    private void copy(File fsource, File fdest) {
        try {
            FileInputStream fis = new FileInputStream(fsource);
            FileOutputStream fos = new FileOutputStream(fdest);
            FileChannel channelSource = fis.getChannel();
            FileChannel channelDest = fos.getChannel();
            if (channelSource.isOpen() && channelDest.isOpen()) {
                channelSource.transferTo(0L, channelSource.size(), channelDest);
                channelSource.close();
                channelDest.close();
            } else {
                System.out.println("error copying file " + fsource.getAbsolutePath());
            }
        }
        catch (FileNotFoundException exc) {
            System.out.println(exc.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    private List<File> selectFiles(File file) {
        if (this.javaFiles == null) {
            this.javaFiles = new ArrayList<File>();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.selectFiles(files[i]);
                }
            }
        } else if (file.getName().endsWith(".java")) {
            this.javaFiles.add(file);
        }
        return this.javaFiles;
    }

    private void convert(List<File> lstFiles) {
        for (File currentFile : lstFiles) {
            this.convert(currentFile);
        }
    }

    private void convert(File file) {
        File newFile = new File(file.getAbsolutePath() + "new");
        try {
            boolean isEmpty = false;
            this.writer.initFileWriter(newFile);
            FileReader freader = new FileReader(file);
            BufferedReader breader = new BufferedReader(freader);
            while (!isEmpty) {
                String line = breader.readLine();
                if (line != null) {
                    String newLine = this.matcher.replace(line);
                    this.writer.write(newLine);
                    continue;
                }
                isEmpty = true;
                this.writer.closeFileWriter();
                this.copy(newFile, file);
                this.delete(newFile);
            }
        }
        catch (IOException exc) {
            System.out.println("error reading file " + exc);
        }
    }
}

