/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;

public class Writer {
    BufferedWriter bwriter;
    boolean isFirstLine;

    public void initFileWriter(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            this.bwriter = new BufferedWriter(fileWriter);
            this.isFirstLine = true;
        }
        catch (IOException exc) {
            System.out.println("error creating filewriter " + file.getAbsolutePath());
        }
    }

    public void closeFileWriter() {
        if (this.bwriter != null) {
            try {
                this.bwriter.flush();
                this.bwriter.close();
            }
            catch (IOException e) {
                System.out.println("error closing filewriter " + this.bwriter.toString());
            }
        }
    }

    public void rewrite(Matcher matcher, String replacement) {
        String text = matcher.replaceAll(replacement);
        if (this.bwriter != null) {
            try {
                if (!this.isFirstLine) {
                    this.bwriter.newLine();
                } else {
                    this.isFirstLine = false;
                }
                this.bwriter.write(text);
            }
            catch (IOException exc) {
                System.out.println("error writing file " + this.bwriter.toString());
            }
        }
    }

    public void write(String text) {
        if (this.bwriter != null) {
            try {
                if (!this.isFirstLine) {
                    this.bwriter.newLine();
                } else {
                    this.isFirstLine = false;
                }
                this.bwriter.write(text);
            }
            catch (IOException exc) {
                System.out.println("error writing file " + this.bwriter.toString());
            }
        }
    }
}

