/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.boot.buildpack.platform.docker.transport.DockerConnectionException;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.transport.Errors;
import org.springframework.boot.buildpack.platform.docker.transport.HttpTransport;
import org.springframework.boot.buildpack.platform.docker.transport.Message;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class HttpClientTransport
implements HttpTransport {
    static final String REGISTRY_AUTH_HEADER = "X-Registry-Auth";
    private final CloseableHttpClient client;
    private final HttpHost host;

    protected HttpClientTransport(CloseableHttpClient client, HttpHost host) {
        Assert.notNull((Object)client, (String)"Client must not be null");
        Assert.notNull((Object)host, (String)"Host must not be null");
        this.client = client;
        this.host = host;
    }

    @Override
    public HttpTransport.Response get(URI uri) {
        return this.execute((HttpUriRequest)new HttpGet(uri));
    }

    @Override
    public HttpTransport.Response post(URI uri) {
        return this.execute((HttpUriRequest)new HttpPost(uri));
    }

    @Override
    public HttpTransport.Response post(URI uri, String registryAuth) {
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPost(uri), registryAuth);
    }

    @Override
    public HttpTransport.Response post(URI uri, String contentType, IOConsumer<OutputStream> writer) {
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPost(uri), contentType, writer);
    }

    @Override
    public HttpTransport.Response put(URI uri, String contentType, IOConsumer<OutputStream> writer) {
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPut(uri), contentType, writer);
    }

    @Override
    public HttpTransport.Response delete(URI uri) {
        return this.execute((HttpUriRequest)new HttpDelete(uri));
    }

    private HttpTransport.Response execute(HttpEntityEnclosingRequestBase request, String contentType, IOConsumer<OutputStream> writer) {
        request.setEntity((HttpEntity)new WritableHttpEntity(contentType, writer));
        return this.execute((HttpUriRequest)request);
    }

    private HttpTransport.Response execute(HttpEntityEnclosingRequestBase request, String registryAuth) {
        if (StringUtils.hasText((String)registryAuth)) {
            request.setHeader(REGISTRY_AUTH_HEADER, registryAuth);
        }
        return this.execute((HttpUriRequest)request);
    }

    private HttpTransport.Response execute(HttpUriRequest request) {
        try {
            CloseableHttpResponse response = this.client.execute(this.host, (HttpRequest)request);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode >= 400 && statusCode <= 500) {
                Errors errors = statusCode != 500 ? this.getErrorsFromResponse(entity) : null;
                Message message = this.getMessageFromResponse(entity);
                throw new DockerEngineException(this.host.toHostString(), request.getURI(), statusCode, statusLine.getReasonPhrase(), errors, message);
            }
            return new HttpClientResponse(response);
        }
        catch (IOException ex) {
            throw new DockerConnectionException(this.host.toHostString(), ex);
        }
    }

    private Errors getErrorsFromResponse(HttpEntity entity) {
        try {
            return (Errors)SharedObjectMapper.get().readValue(entity.getContent(), Errors.class);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Message getMessageFromResponse(HttpEntity entity) {
        try {
            return entity.getContent() != null ? (Message)SharedObjectMapper.get().readValue(entity.getContent(), Message.class) : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    HttpHost getHost() {
        return this.host;
    }

    private static class HttpClientResponse
    implements HttpTransport.Response {
        private final CloseableHttpResponse response;

        HttpClientResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public void close() throws IOException {
            this.response.close();
        }
    }

    private static class WritableHttpEntity
    extends AbstractHttpEntity {
        private final IOConsumer<OutputStream> writer;

        WritableHttpEntity(String contentType, IOConsumer<OutputStream> writer) {
            this.setContentType(contentType);
            this.writer = writer;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            if (this.contentType != null && this.contentType.getValue().equals("application/json")) {
                return this.calculateStringContentLength();
            }
            return -1L;
        }

        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.writer.accept(outputStream);
        }

        public boolean isStreaming() {
            return true;
        }

        private int calculateStringContentLength() {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                this.writer.accept(bytes);
                return bytes.toByteArray().length;
            }
            catch (IOException ex) {
                return -1;
            }
        }
    }
}

