/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Registration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.util.Assert;

public class FilterRegistrationBean
extends RegistrationBean {
    public static final int REQUEST_WRAPPER_FILTER_MAX_ORDER = 0;
    private static Log logger = LogFactory.getLog(FilterRegistrationBean.class);
    static final EnumSet<DispatcherType> ASYNC_DISPATCHER_TYPES = EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.ASYNC);
    static final EnumSet<DispatcherType> NON_ASYNC_DISPATCHER_TYPES = EnumSet.of(DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST);
    private static final String[] DEFAULT_URL_MAPPINGS = new String[]{"/*"};
    private Filter filter;
    private Set<ServletRegistrationBean> servletRegistrationBeans = new LinkedHashSet<ServletRegistrationBean>();
    private Set<String> servletNames = new LinkedHashSet<String>();
    private Set<String> urlPatterns = new LinkedHashSet<String>();
    private EnumSet<DispatcherType> dispatcherTypes;
    private boolean matchAfter = false;

    public FilterRegistrationBean() {
    }

    public FilterRegistrationBean(Filter filter, ServletRegistrationBean ... servletRegistrationBeans) {
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        Assert.notNull((Object)servletRegistrationBeans, (String)"ServletRegistrationBeans must not be null");
        this.filter = filter;
        Collections.addAll(this.servletRegistrationBeans, servletRegistrationBeans);
    }

    protected Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        this.filter = filter;
    }

    public void setServletRegistrationBeans(Collection<? extends ServletRegistrationBean> servletRegistrationBeans) {
        Assert.notNull(servletRegistrationBeans, (String)"ServletRegistrationBeans must not be null");
        this.servletRegistrationBeans = new LinkedHashSet<ServletRegistrationBean>(servletRegistrationBeans);
    }

    public Collection<ServletRegistrationBean> getServletRegistrationBeans() {
        return this.servletRegistrationBeans;
    }

    public void addServletRegistrationBeans(ServletRegistrationBean ... servletRegistrationBeans) {
        Assert.notNull((Object)servletRegistrationBeans, (String)"ServletRegistrationBeans must not be null");
        Collections.addAll(this.servletRegistrationBeans, servletRegistrationBeans);
    }

    public void setServletNames(Collection<String> servletNames) {
        Assert.notNull(servletNames, (String)"ServletNames must not be null");
        this.servletNames = new LinkedHashSet<String>(servletNames);
    }

    public Collection<String> getServletNames() {
        return this.servletNames;
    }

    public void addServletNames(String ... servletNames) {
        Assert.notNull((Object)servletNames, (String)"ServletNames must not be null");
        this.servletNames.addAll(Arrays.asList(servletNames));
    }

    public void setUrlPatterns(Collection<String> urlPatterns) {
        Assert.notNull(urlPatterns, (String)"UrlPatterns must not be null");
        this.urlPatterns = new LinkedHashSet<String>(urlPatterns);
    }

    public Collection<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public void addUrlPatterns(String ... urlPatterns) {
        Assert.notNull((Object)urlPatterns, (String)"UrlPatterns must not be null");
        Collections.addAll(this.urlPatterns, urlPatterns);
    }

    public void setDispatcherTypes(DispatcherType first, DispatcherType ... rest) {
        this.dispatcherTypes = EnumSet.of(first, rest);
    }

    public void setDispatcherTypes(EnumSet<DispatcherType> dispatcherTypes) {
        this.dispatcherTypes = dispatcherTypes;
    }

    public void setMatchAfter(boolean matchAfter) {
        this.matchAfter = matchAfter;
    }

    public boolean isMatchAfter() {
        return this.matchAfter;
    }

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        Assert.notNull((Object)this.filter, (String)"Filter must not be null");
        String name = this.getOrDeduceName(this.filter);
        if (!this.isEnabled()) {
            logger.info((Object)("Filter " + name + " was not registered (disabled)"));
            return;
        }
        FilterRegistration.Dynamic added = servletContext.addFilter(name, this.filter);
        if (added == null) {
            logger.info((Object)("Filter " + name + " was not registered " + "(possibly already registered?)"));
            return;
        }
        this.configure(added);
    }

    protected void configure(FilterRegistration.Dynamic registration) {
        super.configure((Registration.Dynamic)registration);
        EnumSet<DispatcherType> dispatcherTypes = this.dispatcherTypes;
        if (dispatcherTypes == null) {
            dispatcherTypes = this.isAsyncSupported() ? ASYNC_DISPATCHER_TYPES : NON_ASYNC_DISPATCHER_TYPES;
        }
        LinkedHashSet<String> servletNames = new LinkedHashSet<String>();
        for (ServletRegistrationBean servletRegistrationBean : this.servletRegistrationBeans) {
            servletNames.add(servletRegistrationBean.getServletName());
        }
        servletNames.addAll(this.servletNames);
        if (servletNames.isEmpty() && this.urlPatterns.isEmpty()) {
            logger.info((Object)("Mapping filter: '" + registration.getName() + "' to: " + Arrays.asList(DEFAULT_URL_MAPPINGS)));
            registration.addMappingForUrlPatterns(dispatcherTypes, this.matchAfter, DEFAULT_URL_MAPPINGS);
        } else {
            if (servletNames.size() > 0) {
                logger.info((Object)("Mapping filter: '" + registration.getName() + "' to servlets: " + servletNames));
                registration.addMappingForServletNames(dispatcherTypes, this.matchAfter, servletNames.toArray(new String[servletNames.size()]));
            }
            if (this.urlPatterns.size() > 0) {
                logger.info((Object)("Mapping filter: '" + registration.getName() + "' to urls: " + this.urlPatterns));
                registration.addMappingForUrlPatterns(dispatcherTypes, this.matchAfter, this.urlPatterns.toArray(new String[this.urlPatterns.size()]));
            }
        }
    }
}

