/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.CopyContracts;
import org.springframework.cloud.contract.maven.verifier.MavenContractsDownloader;
import org.springframework.cloud.contract.maven.verifier.stubrunner.AetherStubDownloaderFactory;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.converter.SingleFileConverter;
import org.springframework.cloud.contract.verifier.wiremock.DslToWireMockClientConverter;
import org.springframework.cloud.contract.verifier.wiremock.RecursiveFilesConverter;

@Mojo(name="convert", requiresProject=false, defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class ConvertMojo
extends AbstractMojo {
    public static final String DEFAULT_STUBS_DIR = "${project.build.directory}/stubs/";
    public static final String MAPPINGS_PATH = "mappings";
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${basedir}/src/test/resources/contracts")
    private File contractsDirectory;
    @Parameter(defaultValue="${project.build.directory}/stubs/")
    private File stubsDirectory;
    @Parameter(property="contractsDirectory", defaultValue="${basedir}")
    private File source;
    @Parameter(property="stubsDirectory", defaultValue="${basedir}")
    private File destination;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="contractsRepositoryUrl")
    private String contractsRepositoryUrl;
    @Parameter(property="contractDependency")
    private Dependency contractDependency;
    @Parameter(property="contractsPath")
    private String contractsPath;
    @Parameter(property="contractsWorkOffline", defaultValue="false")
    private boolean contractsWorkOffline;
    @Parameter(property="excludeBuildFolders", defaultValue="false")
    private boolean excludeBuildFolders;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;
    private final AetherStubDownloaderFactory aetherStubDownloaderFactory;

    @Inject
    public ConvertMojo(AetherStubDownloaderFactory aetherStubDownloaderFactory) {
        this.aetherStubDownloaderFactory = aetherStubDownloaderFactory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)String.format("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=%s", this.skip));
            return;
        }
        ContractVerifierConfigProperties config = new ContractVerifierConfigProperties();
        config.setExcludeBuildFolders(this.excludeBuildFolders);
        File contractsDirectory = new MavenContractsDownloader(this.project, this.contractDependency, this.contractsPath, this.contractsRepositoryUrl, this.contractsWorkOffline, this.getLog(), this.aetherStubDownloaderFactory, this.repoSession).downloadAndUnpackContractsIfRequired(config, this.contractsDirectory);
        this.getLog().info((CharSequence)("Directory with contract is present at [" + contractsDirectory + "]"));
        new CopyContracts(this.project, this.mavenSession, this.mavenResourcesFiltering, config).copy(contractsDirectory, this.stubsDirectory);
        config.setContractsDslDir(this.isInsideProject() ? contractsDirectory : this.source);
        config.setStubsOutputDir(this.isInsideProject() ? new File(this.stubsDirectory, MAPPINGS_PATH) : this.destination);
        this.getLog().info((CharSequence)"Converting from Spring Cloud Contract Verifier contracts to WireMock stubs mappings");
        this.getLog().info((CharSequence)String.format("     Spring Cloud Contract Verifier contracts directory: %s", config.getContractsDslDir()));
        this.getLog().info((CharSequence)String.format("WireMock stubs mappings directory: %s", config.getStubsOutputDir()));
        RecursiveFilesConverter converter = new RecursiveFilesConverter((SingleFileConverter)new DslToWireMockClientConverter(), config);
        converter.processFiles();
    }

    private boolean isInsideProject() {
        return this.mavenSession.getRequest().isProjectPresent();
    }
}

