/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.settings.validation;

import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Profile;
import shaded.org.apache.maven.settings.Repository;
import shaded.org.apache.maven.settings.Server;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.SettingsProblem;
import shaded.org.apache.maven.settings.building.SettingsProblemCollector;
import shaded.org.apache.maven.settings.validation.SettingsValidator;

@Component(role=SettingsValidator.class)
public class DefaultSettingsValidator
implements SettingsValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";

    @Override
    public void validate(Settings settings, SettingsProblemCollector problems) {
        List<Profile> profiles;
        List<Mirror> mirrors;
        List<Server> servers;
        List<String> pluginGroups;
        if (settings.isUsePluginRegistry()) {
            this.addViolation(problems, SettingsProblem.Severity.WARNING, "usePluginRegistry", null, "is deprecated and has no effect.");
        }
        if ((pluginGroups = settings.getPluginGroups()) != null) {
            for (int i = 0; i < pluginGroups.size(); ++i) {
                String pluginGroup = pluginGroups.get(i).trim();
                if (StringUtils.isBlank(pluginGroup)) {
                    this.addViolation(problems, SettingsProblem.Severity.ERROR, "pluginGroups.pluginGroup[" + i + "]", null, "must not be empty");
                    continue;
                }
                if (pluginGroup.matches(ID_REGEX)) continue;
                this.addViolation(problems, SettingsProblem.Severity.ERROR, "pluginGroups.pluginGroup[" + i + "]", null, "must denote a valid group id and match the pattern [A-Za-z0-9_\\-.]+");
            }
        }
        if ((servers = settings.getServers()) != null) {
            HashSet<String> serverIds = new HashSet<String>();
            for (int i = 0; i < servers.size(); ++i) {
                Server server = servers.get(i);
                this.validateStringNotEmpty(problems, "servers.server[" + i + "].id", server.getId(), null);
                if (serverIds.add(server.getId())) continue;
                this.addViolation(problems, SettingsProblem.Severity.WARNING, "servers.server.id", null, "must be unique but found duplicate server with id " + server.getId());
            }
        }
        if ((mirrors = settings.getMirrors()) != null) {
            for (Mirror mirror : mirrors) {
                this.validateStringNotEmpty(problems, "mirrors.mirror.id", mirror.getId(), mirror.getUrl());
                this.validateBannedCharacters(problems, "mirrors.mirror.id", SettingsProblem.Severity.WARNING, mirror.getId(), null, "\\/:\"<>|?*");
                if ("local".equals(mirror.getId())) {
                    this.addViolation(problems, SettingsProblem.Severity.WARNING, "mirrors.mirror.id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
                }
                this.validateStringNotEmpty(problems, "mirrors.mirror.url", mirror.getUrl(), mirror.getId());
                this.validateStringNotEmpty(problems, "mirrors.mirror.mirrorOf", mirror.getMirrorOf(), mirror.getId());
            }
        }
        if ((profiles = settings.getProfiles()) != null) {
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : profiles) {
                if (!profileIds.add(profile.getId())) {
                    this.addViolation(problems, SettingsProblem.Severity.WARNING, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId());
                }
                String prefix = "profiles.profile[" + profile.getId() + "].";
                this.validateRepositories(problems, profile.getRepositories(), prefix + "repositories.repository");
                this.validateRepositories(problems, profile.getPluginRepositories(), prefix + "pluginRepositories.pluginRepository");
            }
        }
    }

    private void validateRepositories(SettingsProblemCollector problems, List<Repository> repositories, String prefix) {
        HashSet<String> repoIds = new HashSet<String>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(problems, prefix + ".id", repository.getId(), repository.getUrl());
            this.validateBannedCharacters(problems, prefix + ".id", SettingsProblem.Severity.WARNING, repository.getId(), null, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                this.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
            }
            if (!repoIds.add(repository.getId())) {
                this.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".id", null, "must be unique but found duplicate repository with id " + repository.getId());
            }
            this.validateStringNotEmpty(problems, prefix + ".url", repository.getUrl(), repository.getId());
            if (!"legacy".equals(repository.getLayout())) continue;
            this.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + ".layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.");
        }
    }

    private boolean validateStringNotEmpty(SettingsProblemCollector problems, String fieldName, String string, String sourceHint) {
        if (!this.validateNotNull(problems, fieldName, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        this.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private boolean validateNotNull(SettingsProblemCollector problems, String fieldName, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        this.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "is missing");
        return false;
    }

    private boolean validateBannedCharacters(SettingsProblemCollector problems, String fieldName, SettingsProblem.Severity severity, String string, String sourceHint, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                this.addViolation(problems, severity, fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i));
                return false;
            }
        }
        return true;
    }

    private void addViolation(SettingsProblemCollector problems, SettingsProblem.Severity severity, String fieldName, String sourceHint, String message) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(severity, buffer.toString(), -1, -1, null);
    }
}

