/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Lists;
import shaded.com.google.inject.Injector;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.internal.ErrorFormatter;
import shaded.com.google.inject.internal.ErrorId;
import shaded.com.google.inject.internal.InternalErrorDetail;
import shaded.com.google.inject.internal.Messages;
import shaded.com.google.inject.internal.MissingImplementationErrorHints;
import shaded.com.google.inject.spi.ErrorDetail;

final class MissingImplementationError<T>
extends InternalErrorDetail<MissingImplementationError<T>> {
    private final Key<T> key;
    private final ImmutableList<String> suggestions;

    public MissingImplementationError(Key<T> key, Injector injector, List<Object> sources) {
        this(key, MissingImplementationErrorHints.getSuggestions(key, injector), sources);
    }

    private MissingImplementationError(Key<T> key, ImmutableList<String> suggestions, List<Object> sources) {
        super(ErrorId.MISSING_IMPLEMENTATION, String.format("No implementation for %s was bound.", Messages.convert(key)), sources, null);
        this.key = key;
        this.suggestions = suggestions;
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> otherError) {
        return otherError instanceof MissingImplementationError && ((MissingImplementationError)otherError).key.equals(this.key);
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> mergeableErrors, Formatter formatter) {
        if (!this.suggestions.isEmpty()) {
            this.suggestions.forEach(x$0 -> formatter.format((String)x$0, new Object[0]));
        }
        ArrayList<List<Object>> sourcesList = new ArrayList<List<Object>>();
        sourcesList.add(this.getSources());
        sourcesList.addAll(mergeableErrors.stream().map(ErrorDetail::getSources).collect(Collectors.toList()));
        List filteredSourcesList = sourcesList.stream().map(this::trimSource).filter(sources -> !sources.isEmpty()).collect(Collectors.toList());
        if (!filteredSourcesList.isEmpty()) {
            formatter.format("%n%s%n", Messages.bold("Requested by:"));
            int sourceListIndex = 1;
            for (List sources2 : filteredSourcesList) {
                ErrorFormatter.formatSources(sourceListIndex++, Lists.reverse(sources2), formatter);
            }
        }
    }

    @Override
    public MissingImplementationError<T> withSources(List<Object> newSources) {
        return new MissingImplementationError<T>(this.key, this.suggestions, newSources);
    }

    private List<Object> trimSource(List<Object> sources) {
        return sources.stream().filter(source -> !source.equals(this.key)).collect(Collectors.toList());
    }
}

