/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class FromFileProperty
implements Serializable {
    private final File file;
    private final String charset;
    private final Class type;

    public FromFileProperty(File file, Class type) {
        this(file, type, Charset.defaultCharset());
    }

    public FromFileProperty(File file, Class type, Charset charset) {
        this.file = file;
        this.type = type;
        this.charset = charset.toString();
    }

    public boolean isString() {
        return String.class.equals((Object)this.type);
    }

    public boolean isByte() {
        return byte[].class.equals((Object)this.type) || Byte[].class.equals((Object)this.type);
    }

    public String asString() {
        try {
            return new String(this.asBytes(), this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String fileName() {
        return this.file.getName();
    }

    public byte[] asBytes() {
        try {
            return Files.readAllBytes(this.file.toPath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return this.asString();
    }

    public final File getFile() {
        return this.file;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final Class getType() {
        return this.type;
    }
}

