/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder.handlebars;

import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;

public class HandlebarsJsonPathHelper
implements Helper<Map<String, Object>>,
GroovyObject {
    public static final String NAME = "jsonpath";
    public static final String REQUEST_MODEL_NAME = "request";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public HandlebarsJsonPathHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Object apply(Map<String, Object> context, Options options) throws IOException {
        String jsonPath = ShortTypeHandling.castToString((Object)options.param(0));
        Object model = context.get(REQUEST_MODEL_NAME);
        if (model instanceof TestSideRequestTemplateModel) {
            return this.returnObjectForTest(model, jsonPath);
        }
        if (model instanceof RequestTemplateModel) {
            return this.returnObjectForStub(model, jsonPath);
        }
        throw (Throwable)new IllegalArgumentException("Unsupported model");
    }

    private Object returnObjectForStub(Object model, String jsonPath) {
        DocumentContext documentContext = JsonPath.parse((String)((RequestTemplateModel)ScriptBytecodeAdapter.castToType((Object)model, RequestTemplateModel.class)).getBody());
        return documentContext.read(jsonPath, new Predicate[0]);
    }

    private Object returnObjectForTest(Object model, String jsonPath) {
        String body = this.removeSurroundingQuotes(((TestSideRequestTemplateModel)ScriptBytecodeAdapter.castToType((Object)model, TestSideRequestTemplateModel.class)).getRawBody()).replace("\\\"", "\"");
        DocumentContext documentContext = JsonPath.parse((String)body);
        return documentContext.read(jsonPath, new Predicate[0]);
    }

    private String removeSurroundingQuotes(String body) {
        if (body.startsWith("\"") && body.endsWith("\"")) {
            return body.substring(1, body.length() - 1);
        }
        return body;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HandlebarsJsonPathHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

