/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.jms.JmsTracing;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.springframework.beans.factory.BeanFactory;

class LazyMessageListener
implements MessageListener {
    private final BeanFactory beanFactory;
    private final MessageListener delegate;
    private JmsTracing jmsTracing;

    LazyMessageListener(BeanFactory beanFactory, MessageListener delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void onMessage(Message message) {
        this.wrappedDelegate().onMessage(message);
    }

    private JmsTracing jmsTracing() {
        if (this.jmsTracing != null) {
            return this.jmsTracing;
        }
        this.jmsTracing = (JmsTracing)this.beanFactory.getBean(JmsTracing.class);
        return this.jmsTracing;
    }

    private MessageListener wrappedDelegate() {
        return this.jmsTracing().messageListener(this.delegate, true);
    }
}

