/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.sampler.PercentageBasedSampler;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin.DiscoveryClientEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.FallbackHavingEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.HttpZipkinSpanReporter;
import org.springframework.cloud.sleuth.zipkin.ServerPropertiesEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanListener;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={ZipkinProperties.class, SamplerProperties.class})
@ConditionalOnProperty(value={"spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
public class ZipkinAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZipkinSpanReporter reporter(SpanMetricReporter spanMetricReporter, ZipkinProperties zipkin) {
        return new HttpZipkinSpanReporter(zipkin.getBaseUrl(), zipkin.getFlushInterval(), zipkin.getCompression().isEnabled(), spanMetricReporter);
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler defaultTraceSampler(SamplerProperties config) {
        return new PercentageBasedSampler(config);
    }

    @Bean
    public SpanReporter zipkinSpanListener(ZipkinSpanReporter reporter, EndpointLocator endpointLocator, Environment environment, SpanAdjuster spanAdjuster) {
        return new ZipkinSpanListener(reporter, endpointLocator, environment, spanAdjuster);
    }

    @Configuration
    @ConditionalOnClass(value={DiscoveryClient.class})
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="true")
    protected static class DiscoveryClientEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Value(value="${spring.application.name:unknown}")
        private String appName;
        @Autowired(required=false)
        private DiscoveryClient client;

        protected DiscoveryClientEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new FallbackHavingEndpointLocator(this.discoveryClientEndpointLocator(), new ServerPropertiesEndpointLocator(this.serverProperties, this.appName, this.zipkinProperties, this.inetUtils));
        }

        private DiscoveryClientEndpointLocator discoveryClientEndpointLocator() {
            if (this.client != null) {
                return new DiscoveryClientEndpointLocator(this.client, this.zipkinProperties);
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={EndpointLocator.class})
    @ConditionalOnProperty(value={"spring.zipkin.locator.discovery.enabled"}, havingValue="false", matchIfMissing=true)
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Autowired
        private ZipkinProperties zipkinProperties;
        @Autowired(required=false)
        private InetUtils inetUtils;
        @Value(value="${spring.application.name:unknown}")
        private String appName;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new ServerPropertiesEndpointLocator(this.serverProperties, this.appName, this.zipkinProperties, this.inetUtils);
        }
    }
}

