/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;

public final class DynamicDestinationsBindable
implements Bindable {
    private final Map<String, Binding<?>> outputBindings = new HashMap();

    public synchronized void addOutputBinding(String name, Binding<?> binding) {
        this.outputBindings.put(name, binding);
    }

    @Override
    public synchronized Set<String> getOutputs() {
        return Collections.unmodifiableSet(this.outputBindings.keySet());
    }

    @Override
    public synchronized void unbindOutputs(BindingService adapter) {
        for (Map.Entry<String, Binding<?>> entry : this.outputBindings.entrySet()) {
            entry.getValue().unbind();
        }
        this.outputBindings.clear();
    }
}

