/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.PartitionAwareFunctionWrapper;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public final class StreamBridge
implements SmartInitializingSingleton {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, MessageChannel> outputChannelsOnly = new HashMap<String, MessageChannel>();
    private final FunctionCatalog functionCatalog;
    private final FunctionRegistry functionRegistry;
    private BindingServiceProperties bindingServiceProperties;
    private ConfigurableApplicationContext applicationContext;
    private boolean initialized;
    @Autowired
    private BinderAwareChannelResolver dynamicDestinationResolver;

    StreamBridge(FunctionCatalog functionCatalog, FunctionRegistry functionRegistry, BindingServiceProperties bindingServiceProperties, ConfigurableApplicationContext applicationContext) {
        this.functionCatalog = functionCatalog;
        this.functionRegistry = functionRegistry;
        this.applicationContext = applicationContext;
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public boolean send(String bindingName, Object data) {
        return this.send(bindingName, data, MimeTypeUtils.APPLICATION_JSON);
    }

    public boolean send(String bindingName, Object data, MimeType outputContentType) {
        if (!this.outputChannelsOnly.containsKey(bindingName)) {
            this.logger.info((Object)("Binding name '" + bindingName + "' does not exist. This means that value '" + bindingName + "' will be treated as dynamic destination. If this is not your intention please provide 'spring.cloud.stream.source' property"));
            this.outputChannelsOnly.put(bindingName, this.dynamicDestinationResolver.resolveDestination(bindingName));
            FunctionRegistration fr = new FunctionRegistration(v -> v, new String[]{bindingName});
            this.functionRegistry.register(fr.type(FunctionType.from(Object.class).to(Object.class).message()));
        }
        SimpleFunctionRegistry.FunctionInvocationWrapper functionWrapper = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(bindingName, new String[]{outputContentType.toString()});
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindings().get(bindingName);
        ProducerProperties producerProperties = bindingProperties.getProducer();
        Object functionToInvoke = functionWrapper;
        if (producerProperties != null && producerProperties.isPartitioned()) {
            functionToInvoke = new PartitionAwareFunctionWrapper(functionWrapper, this.applicationContext, producerProperties);
        }
        Message resultMessage = (Message)functionToInvoke.apply(data);
        this.outputChannelsOnly.get(bindingName).send(resultMessage);
        return true;
    }

    public void afterSingletonsInstantiated() {
        if (this.initialized) {
            return;
        }
        Map channels = this.applicationContext.getBeansOfType(DirectWithAttributesChannel.class);
        for (Map.Entry channelEntry : channels.entrySet()) {
            if (!((DirectWithAttributesChannel)((Object)channelEntry.getValue())).getAttribute("type").equals("output")) continue;
            this.outputChannelsOnly.put((String)channelEntry.getKey(), (MessageChannel)channelEntry.getValue());
            FunctionRegistration fr = new FunctionRegistration(v -> v, new String[]{(String)channelEntry.getKey()});
            this.functionRegistry.register(fr.type(FunctionType.from(Object.class).to(Object.class).message()));
            this.initialized = true;
        }
    }
}

