/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import com.datastax.driver.core.DataType;
import org.springframework.cassandra.core.Ordering;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.CqlStringUtils;
import org.springframework.util.Assert;

public class ColumnSpecification {
    public static final Ordering DEFAULT_ORDERING = Ordering.ASCENDING;
    private CqlIdentifier name;
    private DataType type;
    private PrimaryKeyType keyType;
    private Ordering ordering;

    public ColumnSpecification name(String name) {
        return this.name(CqlIdentifier.cqlId(name));
    }

    public ColumnSpecification name(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"CqlIdentifier must not be null");
        this.name = name;
        return this;
    }

    public ColumnSpecification type(DataType type) {
        this.type = type;
        return this;
    }

    public ColumnSpecification partitioned() {
        return this.partitioned(true);
    }

    public ColumnSpecification partitioned(boolean partitioned) {
        this.keyType = partitioned ? PrimaryKeyType.PARTITIONED : null;
        this.ordering = null;
        return this;
    }

    public ColumnSpecification clustered() {
        return this.clustered(DEFAULT_ORDERING);
    }

    public ColumnSpecification clustered(Ordering order) {
        return this.clustered(order, true);
    }

    public ColumnSpecification clustered(Ordering order, boolean primary) {
        this.keyType = primary ? PrimaryKeyType.CLUSTERED : null;
        this.ordering = primary ? order : null;
        return this;
    }

    ColumnSpecification keyType(PrimaryKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    ColumnSpecification ordering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    public CqlIdentifier getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public PrimaryKeyType getKeyType() {
        return this.keyType;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public String toCql() {
        return this.toCql(null).toString();
    }

    public StringBuilder toCql(StringBuilder cql) {
        cql = CqlStringUtils.noNull(cql);
        return cql.append(this.name).append(" ").append(this.type);
    }

    public String toString() {
        return this.toCql(null).append(" /* keyType=").append(this.keyType).append(", ordering=").append(this.ordering).append(" */ ").toString();
    }
}

