/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.support;

import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cassandra.support.exception.CassandraAuthenticationException;
import org.springframework.cassandra.support.exception.CassandraConnectionFailureException;
import org.springframework.cassandra.support.exception.CassandraInsufficientReplicasAvailableException;
import org.springframework.cassandra.support.exception.CassandraInternalException;
import org.springframework.cassandra.support.exception.CassandraInvalidConfigurationInQueryException;
import org.springframework.cassandra.support.exception.CassandraInvalidQueryException;
import org.springframework.cassandra.support.exception.CassandraKeyspaceExistsException;
import org.springframework.cassandra.support.exception.CassandraQuerySyntaxException;
import org.springframework.cassandra.support.exception.CassandraReadTimeoutException;
import org.springframework.cassandra.support.exception.CassandraTableExistsException;
import org.springframework.cassandra.support.exception.CassandraTraceRetrievalException;
import org.springframework.cassandra.support.exception.CassandraTruncateException;
import org.springframework.cassandra.support.exception.CassandraTypeMismatchException;
import org.springframework.cassandra.support.exception.CassandraUnauthorizedException;
import org.springframework.cassandra.support.exception.CassandraUncategorizedException;
import org.springframework.cassandra.support.exception.CassandraWriteTimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.ClassUtils;

public class CassandraExceptionTranslator
implements PersistenceExceptionTranslator {
    private static final Set<String> CONNECTION_FAILURE_TYPES = new HashSet<String>(Arrays.asList("NoHostAvailableException", "ConnectionException", "OperationTimedOutException", "TransportException", "BusyConnectionException", "BusyPoolException"));
    private static final Set<String> RESOURCE_FAILURE_TYPES = new HashSet<String>(Arrays.asList("ReadFailureException", "WriteFailureException", "FunctionExecutionException"));

    public DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        if (exception instanceof DataAccessException) {
            return (DataAccessException)exception;
        }
        if (!(exception instanceof DriverException)) {
            return null;
        }
        if (exception instanceof AuthenticationException) {
            return new CassandraAuthenticationException(((AuthenticationException)exception).getHost(), exception.getMessage(), exception);
        }
        if (exception instanceof DriverInternalError) {
            return new CassandraInternalException(exception.getMessage(), exception);
        }
        if (exception instanceof InvalidTypeException) {
            return new CassandraTypeMismatchException(exception.getMessage(), exception);
        }
        if (exception instanceof ReadTimeoutException) {
            return new CassandraReadTimeoutException(((ReadTimeoutException)exception).wasDataRetrieved(), exception.getMessage(), exception);
        }
        if (exception instanceof WriteTimeoutException) {
            WriteType writeType = ((WriteTimeoutException)exception).getWriteType();
            return new CassandraWriteTimeoutException(writeType == null ? null : writeType.name(), exception.getMessage(), exception);
        }
        if (exception instanceof TruncateException) {
            return new CassandraTruncateException(exception.getMessage(), exception);
        }
        if (exception instanceof UnavailableException) {
            UnavailableException ux = (UnavailableException)exception;
            return new CassandraInsufficientReplicasAvailableException(ux.getRequiredReplicas(), ux.getAliveReplicas(), exception.getMessage(), exception);
        }
        if (exception instanceof OverloadedException || exception instanceof BootstrappingException) {
            return new TransientDataAccessResourceException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof AlreadyExistsException) {
            AlreadyExistsException aex = (AlreadyExistsException)exception;
            return aex.wasTableCreation() ? new CassandraTableExistsException(aex.getTable(), exception.getMessage(), exception) : new CassandraKeyspaceExistsException(aex.getKeyspace(), exception.getMessage(), exception);
        }
        if (exception instanceof InvalidConfigurationInQueryException) {
            return new CassandraInvalidConfigurationInQueryException(exception.getMessage(), exception);
        }
        if (exception instanceof InvalidQueryException) {
            return new CassandraInvalidQueryException(exception.getMessage(), exception);
        }
        if (exception instanceof SyntaxError) {
            return new CassandraQuerySyntaxException(exception.getMessage(), exception);
        }
        if (exception instanceof UnauthorizedException) {
            return new CassandraUnauthorizedException(exception.getMessage(), exception);
        }
        if (exception instanceof TraceRetrievalException) {
            return new CassandraTraceRetrievalException(exception.getMessage(), exception);
        }
        if (exception instanceof NoHostAvailableException) {
            return new CassandraConnectionFailureException(((NoHostAvailableException)exception).getErrors(), exception.getMessage(), exception);
        }
        String exceptionType = ClassUtils.getShortName((Class)ClassUtils.getUserClass(exception.getClass()));
        if (CONNECTION_FAILURE_TYPES.contains(exceptionType)) {
            Map<InetSocketAddress, Throwable> errorMap = Collections.emptyMap();
            if (exception instanceof CoordinatorException) {
                CoordinatorException cx = (CoordinatorException)exception;
                errorMap = Collections.singletonMap(cx.getAddress(), exception);
            }
            return new CassandraConnectionFailureException(errorMap, exception.getMessage(), exception);
        }
        if (RESOURCE_FAILURE_TYPES.contains(exceptionType)) {
            return new DataAccessResourceFailureException(exception.getMessage(), (Throwable)exception);
        }
        return new CassandraUncategorizedException(exception.getMessage(), exception);
    }
}

