/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.GraphRepositoryImpl;
import org.springframework.data.neo4j.repository.query.GraphQueryLookupStrategy;
import org.springframework.data.neo4j.repository.support.GraphEntityInformation;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;

public class GraphRepositoryFactory
extends RepositoryFactorySupport {
    private final Session session;

    public GraphRepositoryFactory(Session session) {
        this.session = session;
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        return new GraphEntityInformation(type);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        return this.getTargetRepositoryViaReflection(information, new Object[]{information.getDomainType(), this.session});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return GraphRepositoryImpl.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new GraphQueryLookupStrategy(this.session);
    }
}

