/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.ObjectUtils;

public class RedisOperationChain {
    private Set<PathAndValue> sismember = new LinkedHashSet<PathAndValue>();
    private Set<PathAndValue> orSismember = new LinkedHashSet<PathAndValue>();

    public void sismember(String path, Object value) {
        this.sismember(new PathAndValue(path, value));
    }

    public void sismember(PathAndValue pathAndValue) {
        this.sismember.add(pathAndValue);
    }

    public Set<PathAndValue> getSismember() {
        return this.sismember;
    }

    public void orSismember(String path, Object value) {
        this.orSismember(new PathAndValue(path, value));
    }

    public void orSismember(PathAndValue pathAndValue) {
        this.orSismember.add(pathAndValue);
    }

    public void orSismember(Collection<PathAndValue> next) {
        this.orSismember.addAll(next);
    }

    public Set<PathAndValue> getOrSismember() {
        return this.orSismember;
    }

    public static class PathAndValue {
        private final String path;
        private final Collection<Object> values;

        public PathAndValue(String path, Object singleValue) {
            this.path = path;
            this.values = Collections.singleton(singleValue);
        }

        public PathAndValue(String path, Collection<Object> values) {
            this.path = path;
            this.values = values != null ? values : Collections.emptySet();
        }

        public boolean isSingleValue() {
            return this.values.size() == 1;
        }

        public String getPath() {
            return this.path;
        }

        public Collection<Object> values() {
            return this.values;
        }

        public Object getFirstValue() {
            return this.values.isEmpty() ? null : this.values.iterator().next();
        }

        public String toString() {
            return this.path + ":" + (this.isSingleValue() ? this.getFirstValue() : this.values);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.path);
            return result += ObjectUtils.nullSafeHashCode(this.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PathAndValue)) {
                return false;
            }
            PathAndValue that = (PathAndValue)obj;
            if (!ObjectUtils.nullSafeEquals((Object)this.path, (Object)that.path)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.values, that.values);
        }
    }
}

