/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchException;

class JsonLateObjectEvaluator
implements LateObjectEvaluator {
    @NonNull
    private final ObjectMapper mapper;
    @NonNull
    private final JsonNode valueNode;

    @Override
    public <T> Object evaluate(Class<T> type) {
        try {
            return this.mapper.readValue(this.valueNode.traverse(), type);
        }
        catch (Exception e) {
            throw new PatchException(String.format("Could not read %s into %s!", this.valueNode, type), e);
        }
    }

    @ConstructorProperties(value={"mapper", "valueNode"})
    public JsonLateObjectEvaluator(@NonNull ObjectMapper mapper, @NonNull JsonNode valueNode) {
        if (mapper == null) {
            throw new IllegalArgumentException("mapper is null");
        }
        if (valueNode == null) {
            throw new IllegalArgumentException("valueNode is null");
        }
        this.mapper = mapper;
        this.valueNode = valueNode;
    }
}

