/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETagDoesntMatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ETag {
    public static final ETag NO_ETAG = new ETag(null);
    private final String value;

    private ETag(String value) {
        this.value = StringUtils.trimTrailingCharacter((String)StringUtils.trimLeadingCharacter((String)value, (char)'\"'), (char)'\"');
    }

    public static ETag from(String value) {
        return value == null ? NO_ETAG : new ETag(value);
    }

    public static ETag from(PersistentEntityResource resource) {
        return resource == null ? NO_ETAG : ETag.from(resource.getPersistentEntity(), resource.getContent());
    }

    public static ETag from(PersistentEntity<?, ?> entity, Object bean) {
        return ETag.from(ETag.getVersionInformation(entity, bean));
    }

    public void verify(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return;
        }
        if (!this.equals(ETag.from(entity, target))) {
            throw new ETagDoesntMatchException(target, this);
        }
    }

    public boolean matches(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return false;
        }
        return this.equals(ETag.from(entity, target));
    }

    public HttpHeaders addTo(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"HttpHeaders must not be null!");
        String stringValue = this.toString();
        if (stringValue == null) {
            return headers;
        }
        headers.setETag(stringValue);
        return headers;
    }

    public String toString() {
        return this.value == null ? null : "\"".concat(this.value).concat("\"");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ETag)) {
            return false;
        }
        ETag that = (ETag)obj;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    private static String getVersionInformation(PersistentEntity entity, Object bean) {
        Assert.notNull((Object)entity, (String)"PersistentEntity must not be null!");
        Assert.notNull((Object)bean, (String)"Target bean must not be null!");
        if (!entity.hasVersionProperty()) {
            return null;
        }
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(bean);
        return accessor.getProperty(entity.getVersionProperty()).toString();
    }
}

