/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class EmbeddedResourcesAssembler {
    @NonNull
    private final PersistentEntities entities;
    @NonNull
    private final Associations associations;
    @NonNull
    private final ExcerptProjector projector;
    @NonNull
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);

    public Iterable<EmbeddedWrapper> getEmbeddedResources(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        PersistentEntity entity = this.entities.getPersistentEntity(instance.getClass());
        final ArrayList<EmbeddedWrapper> associationProjections = new ArrayList<EmbeddedWrapper>();
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        final ResourceMetadata metadata = this.associations.getMetadataFor(entity.getType());
        entity.doWithAssociations(new SimpleAssociationHandler(){

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty property = association.getInverse();
                if (!EmbeddedResourcesAssembler.this.associations.isLinkableAssociation(property)) {
                    return;
                }
                if (!EmbeddedResourcesAssembler.this.projector.hasExcerptProjection(property.getActualType())) {
                    return;
                }
                Object value = accessor.getProperty(association.getInverse());
                if (value == null) {
                    return;
                }
                String rel = metadata.getMappingFor(property).getRel();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    if (collection.isEmpty()) {
                        return;
                    }
                    ArrayList<Object> nestedCollection = new ArrayList<Object>();
                    for (Object element : collection) {
                        if (element == null) continue;
                        nestedCollection.add(EmbeddedResourcesAssembler.this.projector.projectExcerpt(element));
                    }
                    associationProjections.add(EmbeddedResourcesAssembler.this.wrappers.wrap(nestedCollection, rel));
                } else {
                    associationProjections.add(EmbeddedResourcesAssembler.this.wrappers.wrap(EmbeddedResourcesAssembler.this.projector.projectExcerpt(value), rel));
                }
            }
        });
        return associationProjections;
    }

    @ConstructorProperties(value={"entities", "associations", "projector"})
    public EmbeddedResourcesAssembler(@NonNull PersistentEntities entities, @NonNull Associations associations, @NonNull ExcerptProjector projector) {
        if (entities == null) {
            throw new IllegalArgumentException("entities is null");
        }
        if (associations == null) {
            throw new IllegalArgumentException("associations is null");
        }
        if (projector == null) {
            throw new IllegalArgumentException("projector is null");
        }
        this.entities = entities;
        this.associations = associations;
        this.projector = projector;
    }
}

