/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class PersistentEntityResourceAssembler
implements ResourceAssembler<Object, PersistentEntityResource> {
    @NonNull
    private final PersistentEntities entities;
    @NonNull
    private final Projector projector;
    @NonNull
    private final Associations associations;
    @NonNull
    private final SelfLinkProvider linkProvider;
    @NonNull
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);

    public PersistentEntityResource toResource(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        return this.wrap(this.projector.projectExcerpt(instance), instance).build();
    }

    public PersistentEntityResource toFullResource(Object instance) {
        Assert.notNull((Object)instance, (String)"Entity instance must not be null!");
        return this.wrap(this.projector.project(instance), instance).build();
    }

    private PersistentEntityResource.Builder wrap(Object instance, Object source) {
        PersistentEntity entity = this.entities.getPersistentEntity(source.getClass());
        return PersistentEntityResource.build(instance, entity).withEmbedded(this.getEmbeddedResources(source)).withLink(this.getSelfLinkFor(source)).withLink(this.linkProvider.createSelfLinkFor(source));
    }

    private Iterable<EmbeddedWrapper> getEmbeddedResources(Object instance) {
        return new EmbeddedResourcesAssembler(this.entities, this.associations, this.projector).getEmbeddedResources(instance);
    }

    public Link getSelfLinkFor(Object instance) {
        Link link = this.linkProvider.createSelfLinkFor(instance);
        return new Link(link.expand(new Object[0]).getHref(), "self");
    }

    @ConstructorProperties(value={"entities", "projector", "associations", "linkProvider"})
    public PersistentEntityResourceAssembler(@NonNull PersistentEntities entities, @NonNull Projector projector, @NonNull Associations associations, @NonNull SelfLinkProvider linkProvider) {
        if (entities == null) {
            throw new IllegalArgumentException("entities is null");
        }
        if (projector == null) {
            throw new IllegalArgumentException("projector is null");
        }
        if (associations == null) {
            throw new IllegalArgumentException("associations is null");
        }
        if (linkProvider == null) {
            throw new IllegalArgumentException("linkProvider is null");
        }
        this.entities = entities;
        this.projector = projector;
        this.associations = associations;
        this.linkProvider = linkProvider;
    }
}

