/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.ExecutorChannelInterceptorAware;
import org.springframework.integration.support.management.PollableChannelManagement;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.util.Assert;

public class PollableAmqpChannel
extends AbstractAmqpChannel
implements PollableChannel,
PollableChannelManagement,
ExecutorChannelInterceptorAware {
    private final String channelName;
    private volatile String queueName;
    private volatile AmqpAdmin amqpAdmin;
    private volatile int executorInterceptorsSize;

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate) {
        super(amqpTemplate);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public PollableAmqpChannel(String channelName, AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        super(amqpTemplate, outboundMapper, inboundMapper);
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    public int getReceiveCount() {
        return this.getMetrics().getReceiveCount();
    }

    public long getReceiveCountLong() {
        return this.getMetrics().getReceiveCountLong();
    }

    public int getReceiveErrorCount() {
        return this.getMetrics().getReceiveErrorCount();
    }

    public long getReceiveErrorCountLong() {
        return this.getMetrics().getReceiveErrorCountLong();
    }

    @Override
    protected String getRoutingKey() {
        return this.queueName;
    }

    protected void onInit() throws Exception {
        super.onInit();
        AmqpTemplate amqpTemplate = this.getAmqpTemplate();
        if (this.queueName == null) {
            if (this.amqpAdmin == null && amqpTemplate instanceof RabbitTemplate) {
                this.amqpAdmin = new RabbitAdmin(((RabbitTemplate)amqpTemplate).getConnectionFactory());
            }
            Assert.notNull((Object)this.amqpAdmin, (String)"If no queueName is configured explicitly, an AmqpAdmin instance must be provided, or the AmqpTemplate must be a RabbitTemplate since the Queue needs to be declared.");
            this.queueName = this.channelName;
            this.amqpAdmin.declareQueue(new Queue(this.queueName));
        }
    }

    public Message<?> receive() {
        AbstractMessageChannel.ChannelInterceptorList interceptorList = this.getInterceptors();
        ArrayDeque interceptorStack = null;
        boolean counted = false;
        boolean countsEnabled = this.isCountsEnabled();
        try {
            if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("preReceive on channel '" + (Object)((Object)this) + "'"));
            }
            if (interceptorList.getInterceptors().size() > 0 && !interceptorList.preReceive((MessageChannel)this, interceptorStack = new ArrayDeque())) {
                return null;
            }
            Object object = this.doReceive();
            if (object == null) {
                if (this.isLoggingEnabled() && this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("postReceive on channel '" + (Object)((Object)this) + "', message is null"));
                }
                return null;
            }
            if (countsEnabled) {
                this.getMetrics().afterReceive();
                counted = true;
            }
            Message message = null;
            message = object instanceof Message ? (Message)object : this.getMessageBuilderFactory().withPayload(object).build();
            if (this.isLoggingEnabled() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("postReceive on channel '" + (Object)((Object)this) + "', message: " + message));
            }
            if (interceptorStack != null) {
                message = interceptorList.postReceive(message, (MessageChannel)this);
                interceptorList.afterReceiveCompletion(message, (MessageChannel)this, null, interceptorStack);
            }
            return message;
        }
        catch (RuntimeException e) {
            if (countsEnabled && !counted) {
                this.getMetrics().afterError();
            }
            if (interceptorStack != null) {
                interceptorList.afterReceiveCompletion(null, (MessageChannel)this, (Exception)e, interceptorStack);
            }
            throw e;
        }
    }

    protected Object doReceive() {
        if (!this.isExtractPayload()) {
            return this.getAmqpTemplate().receiveAndConvert(this.queueName);
        }
        RabbitTemplate rabbitTemplate = this.getRabbitTemplate();
        org.springframework.amqp.core.Message message = rabbitTemplate.receive(this.queueName);
        if (message != null) {
            Object payload = rabbitTemplate.getMessageConverter().fromMessage(message);
            Map headers = this.getInboundHeaderMapper().toHeadersFromRequest(message.getMessageProperties());
            return this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build();
        }
        return null;
    }

    public Message<?> receive(long timeout) {
        if (this.isLoggingEnabled() && this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Calling receive with a timeout value on PollableAmqpChannel. The timeout will be ignored since no receive timeout is supported.");
        }
        return this.receive();
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        for (ChannelInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof ExecutorChannelInterceptor)) continue;
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public void addInterceptor(int index, ChannelInterceptor interceptor) {
        super.addInterceptor(index, interceptor);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            ++this.executorInterceptorsSize;
        }
    }

    public boolean removeInterceptor(ChannelInterceptor interceptor) {
        boolean removed = super.removeInterceptor(interceptor);
        if (removed && interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return removed;
    }

    public ChannelInterceptor removeInterceptor(int index) {
        ChannelInterceptor interceptor = super.removeInterceptor(index);
        if (interceptor instanceof ExecutorChannelInterceptor) {
            --this.executorInterceptorsSize;
        }
        return interceptor;
    }

    public boolean hasExecutorInterceptors() {
        return this.executorInterceptorsSize > 0;
    }
}

