/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.handler;

import org.springframework.expression.Expression;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class FileTransferringMessageHandler<F>
extends AbstractMessageHandler {
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private final FileExistsMode mode;

    public FileTransferringMessageHandler(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
        this.mode = FileExistsMode.REPLACE;
    }

    public FileTransferringMessageHandler(RemoteFileTemplate<F> remoteFileTemplate) {
        this(remoteFileTemplate, FileExistsMode.REPLACE);
    }

    public FileTransferringMessageHandler(RemoteFileTemplate<F> remoteFileTemplate, FileExistsMode mode) {
        Assert.notNull(remoteFileTemplate, (String)"remoteFileTemplate must not be null");
        this.remoteFileTemplate = remoteFileTemplate;
        this.mode = mode;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.remoteFileTemplate.setAutoCreateDirectory(autoCreateDirectory);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileTemplate.setRemoteFileSeparator(remoteFileSeparator);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.remoteFileTemplate.setRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        this.remoteFileTemplate.setTemporaryRemoteDirectoryExpression(temporaryRemoteDirectoryExpression);
    }

    protected String getTemporaryFileSuffix() {
        return this.remoteFileTemplate.getTemporaryFileSuffix();
    }

    protected boolean isUseTemporaryFileName() {
        return this.remoteFileTemplate.isUseTemporaryFileName();
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.remoteFileTemplate.setUseTemporaryFileName(useTemporaryFileName);
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.remoteFileTemplate.setFileNameGenerator(fileNameGenerator);
    }

    public void setCharset(String charset) {
        this.remoteFileTemplate.setCharset(charset);
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.remoteFileTemplate.setTemporaryFileSuffix(temporaryFileSuffix);
    }

    protected void onInit() throws Exception {
        this.remoteFileTemplate.setBeanFactory(this.getBeanFactory());
        this.remoteFileTemplate.afterPropertiesSet();
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        this.remoteFileTemplate.send(message, this.mode);
    }
}

