/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.util.Assert;

public class MapJsonSerializer
implements Serializer<Map<?, ?>>,
Deserializer<Map<?, ?>> {
    private volatile JsonObjectMapper<?, ?> jsonObjectMapper = JsonObjectMapperProvider.newInstance();
    private volatile Deserializer<byte[]> packetDeserializer = new ByteArrayLfSerializer();
    private volatile Serializer<byte[]> packetSerializer = new ByteArrayLfSerializer();

    public void setJsonObjectMapper(JsonObjectMapper<?, ?> jsonObjectMapper) {
        Assert.notNull(jsonObjectMapper, (String)"'jsonObjectMapper' cannot be null");
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public void setPacketDeserializer(Deserializer<byte[]> packetDeserializer) {
        Assert.notNull(packetDeserializer, (String)"'packetDeserializer' cannot be null");
        this.packetDeserializer = packetDeserializer;
    }

    public void setPacketSerializer(Serializer<byte[]> packetSerializer) {
        Assert.notNull(packetSerializer, (String)"'packetSerializer' cannot be null");
        this.packetSerializer = packetSerializer;
    }

    public Map<?, ?> deserialize(InputStream inputStream) throws IOException {
        byte[] bytes = (byte[])this.packetDeserializer.deserialize(inputStream);
        try {
            return (Map)this.jsonObjectMapper.fromJson((Object)new InputStreamReader(new ByteArrayInputStream(bytes)), Map.class);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void serialize(Map<?, ?> object, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.jsonObjectMapper.toJson(object, (Writer)new OutputStreamWriter(baos));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.packetSerializer.serialize((Object)baos.toByteArray(), outputStream);
        outputStream.flush();
    }
}

